/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.security;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.aspect.GenericAlert;
import org.apache.falcon.security.SecurityUtil;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.util.StartupProperties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInitializationService
implements FalconService {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInitializationService.class);
    protected static final String CONFIG_PREFIX = "falcon.service.authentication.";
    protected static final String KERBEROS_KEYTAB = "falcon.service.authentication.kerberos.keytab";
    protected static final String KERBEROS_PRINCIPAL = "falcon.service.authentication.kerberos.principal";
    protected static final String AUTH_TOKEN_VALIDITY_SECONDS = "falcon.service.authentication.token.validity";
    private Timer timer = new Timer();
    private static final String SERVICE_NAME = "Authentication initialization service";
    private static final long DEFAULT_VALIDATE_FREQUENCY_SECS = 86300L;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public void init() throws FalconException {
        if (SecurityUtil.isSecurityEnabled()) {
            long validateFrequency;
            LOG.info("Falcon Kerberos Authentication Enabled!");
            AuthenticationInitializationService.initializeKerberos();
            String authTokenValidity = StartupProperties.get().getProperty(AUTH_TOKEN_VALIDITY_SECONDS);
            try {
                long l = validateFrequency = StringUtils.isNotEmpty(authTokenValidity) ? Long.parseLong(authTokenValidity) - 100L : 86300L;
                if (validateFrequency < 0L) {
                    throw new NumberFormatException("Value provided for startup property \"falcon.service.authentication.token.validity\" should be greater than 100.");
                }
            }
            catch (NumberFormatException nfe) {
                throw new FalconException("Invalid value provided for startup property \"falcon.service.authentication.token.validity\", please provide a valid long number", nfe);
            }
            this.timer.schedule((TimerTask)new TokenValidationThread(), 0L, validateFrequency * 1000L);
        } else {
            LOG.info("Falcon Simple Authentication Enabled!");
            Configuration ugiConf = new Configuration();
            ugiConf.set("hadoop.security.authentication", "simple");
            UserGroupInformation.setConfiguration((Configuration)ugiConf);
        }
    }

    protected static void initializeKerberos() throws FalconException {
        try {
            Properties configuration = StartupProperties.get();
            String principal = configuration.getProperty(KERBEROS_PRINCIPAL);
            Validate.notEmpty((String)principal, (String)"Missing required configuration property: falcon.service.authentication.kerberos.principal");
            principal = org.apache.hadoop.security.SecurityUtil.getServerPrincipal((String)principal, (String)SecurityUtil.getLocalHostName());
            String keytabFilePath = configuration.getProperty(KERBEROS_KEYTAB);
            Validate.notEmpty((String)keytabFilePath, (String)"Missing required configuration property: falcon.service.authentication.kerberos.keytab");
            AuthenticationInitializationService.checkIsReadable(keytabFilePath);
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFilePath);
            LOG.info("Got Kerberos ticket, keytab: {}, Falcon principal: {}", (Object)keytabFilePath, (Object)principal);
        }
        catch (Exception ex) {
            throw new FalconException("Could not initialize Authentication initialization service: " + ex.getMessage(), ex);
        }
    }

    private static void checkIsReadable(String keytabFilePath) {
        File keytabFile = new File(keytabFilePath);
        if (!keytabFile.exists()) {
            throw new IllegalArgumentException("The keytab file does not exist! " + keytabFilePath);
        }
        if (!keytabFile.isFile()) {
            throw new IllegalArgumentException("The keytab file cannot be a directory! " + keytabFilePath);
        }
        if (!keytabFile.canRead()) {
            throw new IllegalArgumentException("The keytab file is not readable! " + keytabFilePath);
        }
    }

    @Override
    public void destroy() throws FalconException {
        this.timer.cancel();
    }

    private static class TokenValidationThread
    extends TimerTask {
        private TokenValidationThread() {
        }

        @Override
        public void run() {
            try {
                LOG.debug("Revalidating Auth Token at : {} with auth method {}", (Object)new Date(), (Object)UserGroupInformation.getLoginUser().getAuthenticationMethod().name());
                UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
            }
            catch (Throwable t) {
                LOG.error("Error in Auth Token revalidation task: ", t);
                GenericAlert.initializeKerberosFailed("Exception in Auth Token revalidation : ", t);
            }
        }
    }
}

