/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.v0.feed.LocationType;
import org.apache.falcon.resource.APIResult;

@XmlRootElement(name="feeds")
@XmlAccessorType(value=XmlAccessType.FIELD)
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class FeedLookupResult
extends APIResult {
    @XmlElement(name="elements")
    private FeedProperties[] elements;

    private FeedLookupResult() {
    }

    public FeedLookupResult(APIResult.Status status, String message) {
        super(status, message);
    }

    public FeedProperties[] getElements() {
        return this.elements;
    }

    public void setElements(FeedProperties[] elements) {
        this.elements = elements;
    }

    @Override
    public Object[] getCollection() {
        return this.getElements();
    }

    @Override
    public void setCollection(Object[] items) {
        if (items == null) {
            this.setElements(new FeedProperties[0]);
        } else {
            FeedProperties[] newInstances = new FeedProperties[items.length];
            for (int index = 0; index < items.length; ++index) {
                newInstances[index] = (FeedProperties)items[index];
            }
            this.setElements(newInstances);
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.elements != null) {
            for (FeedProperties element : this.elements) {
                buffer.append(element.toString());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    @XmlRootElement(name="feed")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class FeedProperties {
        @XmlElement
        private String feedName;
        @XmlElement
        private LocationType locationType;
        @XmlElement
        private String clusterName;

        public FeedProperties(String feedName, LocationType locationType, String clusterName) {
            this.clusterName = clusterName;
            this.locationType = locationType;
            this.feedName = feedName;
        }

        private FeedProperties() {
        }

        public void setFeedName(String feedName) {
            this.feedName = feedName;
        }

        public void setLocationType(LocationType locationType) {
            this.locationType = locationType;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getFeedName() {
            return this.feedName;
        }

        public LocationType getLocationType() {
            return this.locationType;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedProperties that = (FeedProperties)o;
            if (!StringUtils.equals(this.clusterName, that.clusterName)) {
                return false;
            }
            if (this.locationType != that.locationType) {
                return false;
            }
            return StringUtils.equals(this.feedName, that.feedName);
        }

        public int hashCode() {
            int result = this.feedName.hashCode();
            result = 31 * result + (this.locationType != null ? this.locationType.hashCode() : 0);
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.feedName + "  (CLUSTER:" + this.clusterName + ")  (LocationType:" + this.locationType.name() + ")";
        }
    }
}

