/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Frequency {
    private static final Pattern PATTERN = Pattern.compile("(minutes|hours|days|months)\\((\\d+)\\)");
    private TimeUnit timeUnit;
    private String frequency;

    public Frequency(String freq, TimeUnit timeUnit) {
        this.frequency = freq;
        this.timeUnit = timeUnit;
    }

    public Frequency(String strValue) {
        Matcher matcher = PATTERN.matcher(strValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid frequency: " + strValue);
        }
        this.timeUnit = TimeUnit.valueOf(matcher.group(1));
        this.frequency = matcher.group(2);
    }

    public static Frequency fromString(String strValue) {
        return new Frequency(strValue);
    }

    public static String toString(Frequency freq) {
        return freq == null ? null : freq.toString();
    }

    public String toString() {
        return this.timeUnit.name() + "(" + this.frequency + ")";
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public int getFrequencyAsInt() {
        return Integer.parseInt(this.frequency);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency freq = (Frequency)obj;
        return this == freq || this.getFrequency().equals(freq.getFrequency()) && this.getTimeUnit() == freq.getTimeUnit();
    }

    public int hashCode() {
        int result = this.timeUnit.hashCode();
        result = 31 * result + this.frequency.hashCode();
        return result;
    }

    public static enum TimeUnit {
        minutes(12),
        hours(10),
        days(5),
        months(2);

        private int calendarUnit;

        private TimeUnit(int calendarUnit) {
            this.calendarUnit = calendarUnit;
        }

        public int getCalendarUnit() {
            return this.calendarUnit;
        }
    }
}

