/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.falcon.entity.v0.AccessControlList;
import org.apache.falcon.entity.v0.EntityType;

public abstract class Entity {
    public abstract String getName();

    public abstract String getTags();

    public abstract AccessControlList getACL();

    public EntityType getEntityType() {
        for (EntityType type : EntityType.values()) {
            if (!type.getEntityClass().equals(this.getClass())) continue;
            return type;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Entity entity = (Entity)o;
        String name = this.getName();
        return !(name == null ? entity.getName() != null : !name.equals(entity.getName()));
    }

    public int hashCode() {
        String clazz = this.getClass().getName();
        String name = this.getName();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + clazz.hashCode();
        return result;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = this.getEntityType().getMarshaller();
            marshaller.marshal((Object)this, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Entity fromString(EntityType type, String str) {
        try {
            Unmarshaller unmarshaler = type.getUnmarshaller();
            return (Entity)unmarshaler.unmarshal((Reader)new StringReader(str));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toShortString() {
        return "(" + this.getEntityType().name().toLowerCase() + ") " + this.getName();
    }

    public Entity copy() {
        return Entity.fromString(this.getEntityType(), this.toString());
    }
}

