/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class DateValidator {
    private static final String DATE_PATTERN = "(2\\d\\d\\d|19\\d\\d)-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])T([0-1][0-9]|2[0-3]):([0-5][0-9])Z";
    private static final Pattern PATTERN = Pattern.compile("(2\\d\\d\\d|19\\d\\d)-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])T([0-1][0-9]|2[0-3]):([0-5][0-9])Z");

    private DateValidator() {
    }

    public static boolean validate(String date) {
        if (StringUtils.isBlank(date)) {
            return false;
        }
        Matcher matcher = PATTERN.matcher(date);
        if (matcher.matches()) {
            matcher.reset();
            if (matcher.find()) {
                int year = Integer.parseInt(matcher.group(1));
                String month = matcher.group(2);
                String day = matcher.group(3);
                if (day.equals("31") && (month.equals("4") || month.equals("6") || month.equals("9") || month.equals("11") || month.equals("04") || month.equals("06") || month.equals("09"))) {
                    return false;
                }
                if (month.equals("2") || month.equals("02")) {
                    if (year % 4 == 0) {
                        return !day.equals("30") && !day.equals("31");
                    }
                    return !day.equals("29") && !day.equals("30") && !day.equals("31");
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

