/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.ClusterHelper;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.security.SecurityUtil;

public final class HiveUtil {
    public static final String METASTOREURIS = "hive.metastore.uris";
    public static final String METASTORE_URI = "hcat.metastore.uri";
    public static final String NODE = "hcatNode";
    public static final String METASTORE_UGI = "hive.metastore.execute.setugi";

    private HiveUtil() {
    }

    public static Properties getHiveCredentials(Cluster cluster) {
        String metaStoreUrl = ClusterHelper.getRegistryEndPoint(cluster);
        if (StringUtils.isBlank(metaStoreUrl)) {
            throw new IllegalStateException("Registry interface is not defined in cluster: " + cluster.getName());
        }
        Properties hiveCredentials = new Properties();
        hiveCredentials.put(METASTOREURIS, metaStoreUrl);
        hiveCredentials.put(METASTORE_UGI, "true");
        hiveCredentials.put(NODE, metaStoreUrl.replace("thrift", "hcat"));
        hiveCredentials.put(METASTORE_URI, metaStoreUrl);
        if (SecurityUtil.isSecurityEnabled()) {
            String principal = ClusterHelper.getPropertyValue(cluster, "hive.metastore.kerberos.principal");
            hiveCredentials.put("hive.metastore.kerberos.principal", principal);
            hiveCredentials.put("hcat.metastore.principal", principal);
            hiveCredentials.put("hive.metastore.sasl.enabled", "true");
        }
        return hiveCredentials;
    }
}

