/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import com.sun.jersey.api.client.ClientHandlerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.cli.FalconAdminCLI;
import org.apache.falcon.cli.FalconEntityCLI;
import org.apache.falcon.cli.FalconExtensionCLI;
import org.apache.falcon.cli.FalconInstanceCLI;
import org.apache.falcon.cli.FalconMetadataCLI;
import org.apache.falcon.cliParser.CLIParser;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.resource.EntityList;
import org.apache.falcon.resource.InstancesResult;
import org.apache.falcon.resource.InstancesSummaryResult;

public class FalconCLI {
    public static final AtomicReference<PrintStream> ERR = new AtomicReference<PrintStream>(System.err);
    public static final AtomicReference<PrintStream> OUT = new AtomicReference<PrintStream>(System.out);
    private static final String FALCON_URL = "FALCON_URL";
    private final Properties clientProperties = this.getClientProperties();
    private static final String[] FALCON_HELP = new String[]{"the env variable 'FALCON_URL' is used as default value for the '-url' option", "custom headers for Falcon web services can be specified using '-Dheader:NAME=VALUE'"};

    public static void main(String[] args) throws Exception {
        System.exit(new FalconCLI().run(args));
    }

    public synchronized int run(String[] args) throws Exception {
        CLIParser parser = new CLIParser("falcon", FALCON_HELP);
        FalconAdminCLI adminCLI = new FalconAdminCLI();
        FalconEntityCLI entityCLI = new FalconEntityCLI();
        FalconInstanceCLI instanceCLI = new FalconInstanceCLI();
        FalconMetadataCLI metadataCLI = new FalconMetadataCLI();
        FalconExtensionCLI extensionCLI = new FalconExtensionCLI();
        parser.addCommand("admin", "", "admin operations", adminCLI.createAdminOptions(), true);
        parser.addCommand("help", "", "display usage", new Options(), false);
        parser.addCommand("entity", "", "Entity operations like submit, suspend, resume, delete, status, definition, submitAndSchedule", entityCLI.createEntityOptions(), false);
        parser.addCommand("instance", "", "Process instances operations like running, status, kill, suspend, resume, rerun, logs, search", instanceCLI.createInstanceOptions(), false);
        parser.addCommand("metadata", "", "Metadata operations like list, relations", metadataCLI.createMetadataOptions(), true);
        parser.addCommand("extension", "", "Extension operations like enumerate, definition, describe, list, instances, submit, submitAndSchedule, schedule, suspend, resume, delete, update, validate", extensionCLI.createExtensionOptions(), true);
        parser.addCommand("version", "", "show client version", new Options(), false);
        try {
            CLIParser.Command command = parser.parse(args);
            int exitValue = 0;
            if (command.getName().equals("help")) {
                parser.showHelp();
            } else {
                CommandLine commandLine = command.getCommandLine();
                String falconUrl = this.getFalconEndpoint(commandLine);
                FalconClient client = new FalconClient(falconUrl, this.clientProperties);
                this.setDebugMode(client, commandLine.hasOption("debug"));
                if (command.getName().equals("admin")) {
                    exitValue = adminCLI.adminCommand(commandLine, client, falconUrl);
                } else if (command.getName().equals("entity")) {
                    entityCLI.entityCommand(commandLine, client);
                } else if (command.getName().equals("instance")) {
                    instanceCLI.instanceCommand(commandLine, client);
                } else if (command.getName().equals("metadata")) {
                    metadataCLI.metadataCommand(commandLine, client);
                } else if (command.getName().equals("extension")) {
                    extensionCLI.extensionCommand(commandLine, client);
                }
            }
            return exitValue;
        }
        catch (ParseException ex) {
            ERR.get().println("Invalid sub-command: " + ex.getMessage());
            ERR.get().println();
            ERR.get().println(parser.shortHelp());
            ERR.get().println("Stacktrace:");
            ex.printStackTrace();
            return -1;
        }
        catch (ClientHandlerException ex) {
            ERR.get().print("Unable to connect to Falcon server, please check if the URL is correct and Falcon server is up and running\n");
            ERR.get().println("Stacktrace:");
            ex.printStackTrace();
            return -1;
        }
        catch (FalconCLIException e) {
            ERR.get().println("ERROR: " + e.getMessage());
            return -1;
        }
        catch (Exception ex) {
            ERR.get().println("Stacktrace:");
            ex.printStackTrace();
            return -1;
        }
    }

    protected Integer parseIntegerInput(String optionValue, Integer defaultVal, String optionName) throws FalconCLIException {
        Integer integer = defaultVal;
        if (optionValue != null) {
            try {
                return Integer.parseInt(optionValue);
            }
            catch (NumberFormatException e) {
                throw new FalconCLIException("Input value provided for queryParam \"" + optionName + "\" is not a valid Integer");
            }
        }
        return integer;
    }

    protected void validateEntityTypeForSummary(String type) throws FalconCLIException {
        EntityType entityType = EntityType.getEnum(type);
        if (!entityType.isSchedulable()) {
            throw new FalconCLIException("Invalid entity type " + (Object)((Object)entityType) + " for EntitySummary API. Valid options are feed or process");
        }
    }

    protected void validateNotEmpty(String paramVal, String paramName) throws FalconCLIException {
        if (StringUtils.isBlank(paramVal)) {
            throw new FalconCLIException("Missing argument : " + paramName);
        }
    }

    protected void validateSortOrder(String sortOrder) throws FalconCLIException {
        if (!(StringUtils.isBlank(sortOrder) || sortOrder.equalsIgnoreCase("asc") || sortOrder.equalsIgnoreCase("desc"))) {
            throw new FalconCLIException("Value for param sortOrder should be \"asc\" or \"desc\". It is  : " + sortOrder);
        }
    }

    protected String getColo(String colo) throws FalconCLIException, IOException {
        if (colo == null) {
            Properties prop = this.getClientProperties();
            colo = prop.getProperty("current.colo", "*");
        }
        return colo;
    }

    protected void validateFilterBy(String filterBy, String filterType) throws FalconCLIException {
        String[] filterSplits;
        if (StringUtils.isEmpty(filterBy)) {
            return;
        }
        for (String s : filterSplits = filterBy.split(",")) {
            String[] tempKeyVal = s.split(":", 2);
            try {
                if (filterType.equals("entity")) {
                    EntityList.EntityFilterByFields.valueOf(tempKeyVal[0].toUpperCase());
                    continue;
                }
                if (filterType.equals("instance")) {
                    InstancesResult.InstanceFilterFields.valueOf(tempKeyVal[0].toUpperCase());
                    continue;
                }
                if (filterType.equals("summary")) {
                    InstancesSummaryResult.InstanceSummaryFilterFields.valueOf(tempKeyVal[0].toUpperCase());
                    continue;
                }
                throw new IllegalArgumentException("Invalid API call: filterType is not valid");
            }
            catch (IllegalArgumentException ie) {
                throw new FalconCLIException("Invalid filterBy argument : " + tempKeyVal[0] + " in : " + s);
            }
        }
    }

    protected void validateOrderBy(String orderBy, String action) throws FalconCLIException {
        if (StringUtils.isBlank(orderBy)) {
            return;
        }
        if (action.equals("instance") ? Arrays.asList("status", "cluster", "starttime", "endtime").contains(orderBy.toLowerCase()) : (action.equals("entity") ? Arrays.asList("type", "name").contains(orderBy.toLowerCase()) : action.equals("summary") && Arrays.asList("cluster").contains(orderBy.toLowerCase()))) {
            return;
        }
        throw new FalconCLIException("Invalid orderBy argument : " + orderBy);
    }

    protected String getFalconEndpoint(CommandLine commandLine) throws FalconCLIException, IOException {
        String url = commandLine.getOptionValue("url");
        if (url == null) {
            url = System.getenv(FALCON_URL);
        }
        if (url == null && this.clientProperties.containsKey("falcon.url")) {
            url = this.clientProperties.getProperty("falcon.url");
        }
        if (url == null) {
            throw new FalconCLIException("Failed to get falcon url from cmdline, or environment or client properties");
        }
        return url;
    }

    private void setDebugMode(FalconClient client, boolean debugOpt) {
        String debug = System.getenv("FALCON_DEBUG");
        if (debugOpt) {
            client.setDebugMode(true);
        } else if (StringUtils.isNotBlank(debug)) {
            System.out.println("FALCON_DEBUG: " + debug);
            if (debug.trim().toLowerCase().equals("true")) {
                client.setDebugMode(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getClientProperties() throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = FalconCLI.class.getResourceAsStream("/client.properties");
            Properties prop = new Properties();
            if (inputStream != null) {
                prop.load(inputStream);
            }
            Properties properties = prop;
            return properties;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

