/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cleanup;

import java.io.IOException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.ClusterHelper;
import org.apache.falcon.entity.EntityUtil;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.AccessControlList;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.hadoop.HadoopClientFactory;
import org.apache.falcon.security.CurrentUser;
import org.apache.falcon.util.DeploymentUtil;
import org.apache.falcon.util.RuntimeProperties;
import org.apache.falcon.util.StartupProperties;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCleanupHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractCleanupHandler.class);
    protected static final ConfigurationStore STORE = ConfigurationStore.get();
    public static final ExpressionEvaluator EVALUATOR = new ExpressionEvaluatorImpl();
    public static final ExpressionHelper RESOLVER = ExpressionHelper.get();

    protected long getRetention(Entity entity, Frequency.TimeUnit timeUnit) throws FalconException {
        String retention = this.getRetentionValue(timeUnit);
        try {
            return (Long)EVALUATOR.evaluate("${" + retention + "}", Long.class, (VariableResolver)RESOLVER, (FunctionMapper)RESOLVER);
        }
        catch (ELException e) {
            throw new FalconException("Unable to evalue retention limit: " + retention + " for entity: " + entity.getName());
        }
    }

    private String getRetentionValue(Frequency.TimeUnit timeunit) {
        String defaultValue;
        switch (timeunit) {
            case minutes: {
                defaultValue = "hours(24)";
                break;
            }
            case hours: {
                defaultValue = "days(3)";
                break;
            }
            case days: {
                defaultValue = "days(12)";
                break;
            }
            case months: {
                defaultValue = "months(3)";
                break;
            }
            default: {
                defaultValue = "days(1)";
            }
        }
        return RuntimeProperties.get().getProperty("log.cleanup.frequency." + (Object)((Object)timeunit) + ".retention", defaultValue);
    }

    protected FileStatus[] getAllLogs(FileSystem fs, Cluster cluster, Entity entity) throws FalconException {
        FileStatus[] paths;
        try {
            Path logPath = this.getLogPath(cluster, entity);
            paths = fs.globStatus(logPath);
        }
        catch (IOException e) {
            throw new FalconException(e);
        }
        return paths;
    }

    private Path getLogPath(Cluster cluster, Entity entity) {
        return new Path(EntityUtil.getLogPath(cluster, entity), this.getRelativeLogPath());
    }

    private FileSystem getFileSystemAsEntityOwner(Cluster cluster, Entity entity) throws FalconException {
        try {
            AccessControlList acl = entity.getACL();
            if (acl != null) {
                CurrentUser.authenticate(acl.getOwner());
            }
            return HadoopClientFactory.get().createProxiedFileSystem(ClusterHelper.getConfiguration(cluster));
        }
        catch (Exception e) {
            throw new FalconException(e);
        }
    }

    protected void delete(String clusterName, Entity entity, long retention) throws FalconException {
        Cluster currentCluster = (Cluster)STORE.get(EntityType.CLUSTER, clusterName);
        if (!this.isClusterInCurrentColo(currentCluster.getColo())) {
            LOG.info("Ignoring cleanup for {}: {} in cluster: {} as this does not belong to current colo", new Object[]{entity.getEntityType(), entity.getName(), clusterName});
            return;
        }
        LOG.info("Cleaning up logs for {}: {} in cluster: {} with retention: {}", new Object[]{entity.getEntityType(), entity.getName(), clusterName, retention});
        FileSystem fs = this.getFileSystemAsEntityOwner(currentCluster, entity);
        FileStatus[] logs = this.getAllLogs(fs, currentCluster, entity);
        this.deleteInternal(fs, currentCluster, entity, retention, logs);
    }

    private void deleteInternal(FileSystem fs, Cluster cluster, Entity entity, long retention, FileStatus[] logs) throws FalconException {
        if (logs == null || logs.length == 0) {
            LOG.info("Nothing to delete for cluster: {}, entity: {}", (Object)cluster.getName(), (Object)entity.getName());
            return;
        }
        long now = System.currentTimeMillis();
        for (FileStatus log : logs) {
            if (now - log.getModificationTime() > retention) {
                try {
                    boolean isDeleted = fs.delete(log.getPath(), true);
                    LOG.error(isDeleted ? "Deleted path: {}" : "Unable to delete path: {}", (Object)log.getPath());
                    this.deleteParentIfEmpty(fs, log.getPath().getParent());
                    continue;
                }
                catch (IOException e) {
                    throw new FalconException(" Unable to delete log file : " + log.getPath() + " for entity " + entity.getName() + " for cluster: " + cluster.getName(), e);
                }
            }
            LOG.info("Retention limit: {} is less than modification {} for path: {}", new Object[]{retention, now - log.getModificationTime(), log.getPath()});
        }
    }

    private void deleteParentIfEmpty(FileSystem fs, Path parent) throws IOException {
        FileStatus[] files = fs.listStatus(parent);
        if (files != null && files.length == 0) {
            LOG.info("Parent path: {} is empty, deleting path", (Object)parent);
            fs.delete(parent, true);
            this.deleteParentIfEmpty(fs, parent.getParent());
        }
    }

    public abstract void cleanup() throws FalconException;

    protected abstract String getRelativeLogPath();

    protected boolean isClusterInCurrentColo(String colo) {
        String currentColo = StartupProperties.get().getProperty("current.colo", "default");
        return DeploymentUtil.isEmbeddedMode() || currentColo.equals(colo);
    }
}

