/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.RedisExecProvider;
import redis.embedded.RedisServerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisServer
extends AbstractRedisInstance {
    private static final String REDIS_READY_PATTERN = ".*The server is now ready to accept connections on port.*";
    private static final int DEFAULT_REDIS_PORT = 6379;

    public RedisServer() throws IOException {
        this(6379);
    }

    public RedisServer(int port) throws IOException {
        super(port);
        File executable = RedisExecProvider.defaultProvider().get();
        this.args = Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port));
    }

    public RedisServer(File executable, int port) {
        super(port);
        this.args = Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port));
    }

    public RedisServer(RedisExecProvider redisExecProvider, int port) throws IOException {
        super(port);
        this.args = Arrays.asList(redisExecProvider.get().getAbsolutePath(), "--port", Integer.toString(port));
    }

    RedisServer(List<String> args, int port) {
        super(port);
        this.args = new ArrayList<String>(args);
    }

    public static RedisServerBuilder builder() {
        return new RedisServerBuilder();
    }

    @Override
    protected String redisReadyPattern() {
        return REDIS_READY_PATTERN;
    }
}

