/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit;

import io.specto.hoverfly.junit.AbstractBuilder;
import io.specto.hoverfly.junit.HoverflyMode;
import io.specto.hoverfly.junit.HoverflyRule;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;

public class SimulateBuilder
extends AbstractBuilder {
    private static final HoverflyMode hoverflyMode = HoverflyMode.SIMULATE;
    private final Optional<String> serviceDataClasspath;
    private final Optional<URL> serviceDataURL;

    public SimulateBuilder(String serviceDataClasspath) {
        this.serviceDataClasspath = Optional.of(serviceDataClasspath);
        this.serviceDataURL = Optional.empty();
    }

    public SimulateBuilder(URL url) {
        this.serviceDataClasspath = Optional.empty();
        this.serviceDataURL = Optional.of(url);
    }

    @Override
    public SimulateBuilder withProxyPort(int proxyPort) {
        super.withProxyPort(proxyPort);
        return this;
    }

    @Override
    public SimulateBuilder withAdminPort(int adminPort) {
        super.withAdminPort(adminPort);
        return this;
    }

    @Override
    public SimulateBuilder proxyLocalHost() {
        super.proxyLocalHost();
        return this;
    }

    @Override
    public HoverflyRule build() {
        try {
            if (this.serviceDataClasspath.isPresent()) {
                return new HoverflyRule(this.serviceDataClasspath.get(), this.proxyPort, this.adminPort, hoverflyMode, this.proxyLocalHost);
            }
            return new HoverflyRule(this.serviceDataURL.get(), this.proxyPort, this.adminPort, hoverflyMode, this.proxyLocalHost);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Unable to build rule", e);
        }
    }
}

