/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.GlobalActions;
import io.specto.hoverfly.junit.core.model.HoverflyData;
import io.specto.hoverfly.junit.core.model.HoverflyMetaData;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface SimulationSource {
    public static final ObjectReader OBJECT_READER = new ObjectMapper().readerFor(Simulation.class);
    public static final String HOVERFLY_ROOT = "hoverfly/";

    public static SimulationSource url(URL url) {
        return () -> {
            try {
                return (Simulation)OBJECT_READER.readValue(url);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read simulation", e);
            }
        };
    }

    public static SimulationSource url(String url) {
        return () -> {
            try {
                return (Simulation)OBJECT_READER.readValue(new URL(url));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read simulation", e);
            }
        };
    }

    public static SimulationSource classpath(String classpath) {
        return () -> {
            try {
                return (Simulation)OBJECT_READER.readValue(HoverflyUtils.findResourceOnClasspath(classpath));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load classpath resource: '" + classpath + "'", e);
            }
        };
    }

    public static SimulationSource defaultPath(String pathString) {
        return () -> {
            try {
                String fullClasspath = HOVERFLY_ROOT + pathString;
                return (Simulation)OBJECT_READER.readValue(HoverflyUtils.findResourceOnClasspath(fullClasspath));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load default path resource: '" + pathString + "'", e);
            }
        };
    }

    public static SimulationSource file(Path path) {
        return () -> {
            try {
                return (Simulation)OBJECT_READER.readValue(path.toFile());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load file resource: '" + path.toString() + "'", e);
            }
        };
    }

    public static SimulationSource dsl(StubServiceBuilder ... stubServiceBuilder) {
        return () -> {
            Set<RequestResponsePair> pairs = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getRequestResponsePairs).flatMap(Collection::stream).collect(Collectors.toSet());
            List<DelaySettings> delaySettings = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getDelaySettings).flatMap(Collection::stream).collect(Collectors.toList());
            return new Simulation(new HoverflyData(pairs, new GlobalActions(delaySettings)), new HoverflyMetaData());
        };
    }

    public static SimulationSource simulation(Simulation simulation) {
        return () -> simulation;
    }

    public static SimulationSource empty() {
        return () -> new Simulation(new HoverflyData(Collections.emptySet(), new GlobalActions(Collections.emptyList())), new HoverflyMetaData());
    }

    public Simulation getSimulation();
}

