/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.FieldMatcher;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceDelaySettingsBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import io.specto.hoverfly.junit.dsl.matchers.PlainTextFieldMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StubServiceBuilder {
    private static final String SEPARATOR = "://";
    private final FieldMatcher destination;
    private FieldMatcher scheme;
    private final Set<RequestResponsePair> requestResponsePairs = new HashSet<RequestResponsePair>();
    private final List<DelaySettings> delaySettings = new ArrayList<DelaySettings>();

    StubServiceBuilder(String baseUrl) {
        String[] elements = baseUrl.split(SEPARATOR);
        if (baseUrl.contains(SEPARATOR)) {
            this.scheme = FieldMatcher.exactlyMatches(elements[0]);
            this.destination = FieldMatcher.exactlyMatches(elements[1]);
        } else {
            this.destination = FieldMatcher.exactlyMatches(elements[0]);
        }
    }

    StubServiceBuilder(PlainTextFieldMatcher matcher) {
        this.destination = matcher.getFieldMatcher();
    }

    public RequestMatcherBuilder get(String path) {
        return this.get(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder get(PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, FieldMatcher.exactlyMatches("GET"), this.scheme, this.destination, path.getFieldMatcher());
    }

    public RequestMatcherBuilder delete(String path) {
        return this.delete(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder delete(PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, FieldMatcher.exactlyMatches("DELETE"), this.scheme, this.destination, path.getFieldMatcher());
    }

    public RequestMatcherBuilder put(String path) {
        return this.put(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder put(PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, FieldMatcher.exactlyMatches("PUT"), this.scheme, this.destination, path.getFieldMatcher());
    }

    public RequestMatcherBuilder post(String path) {
        return this.post(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder post(PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, FieldMatcher.exactlyMatches("POST"), this.scheme, this.destination, path.getFieldMatcher());
    }

    public RequestMatcherBuilder patch(String path) {
        return this.patch(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder patch(PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, FieldMatcher.exactlyMatches("PATCH"), this.scheme, this.destination, path.getFieldMatcher());
    }

    public RequestMatcherBuilder anyMethod(String path) {
        return this.anyMethod(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder anyMethod(PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, null, this.scheme, this.destination, path.getFieldMatcher());
    }

    public Set<RequestResponsePair> getRequestResponsePairs() {
        return Collections.unmodifiableSet(this.requestResponsePairs);
    }

    StubServiceBuilder addRequestResponsePair(RequestResponsePair requestResponsePair) {
        this.requestResponsePairs.add(requestResponsePair);
        return this;
    }

    String getDestination() {
        return this.destination.getExactMatch();
    }

    public StubServiceDelaySettingsBuilder andDelay(int delay, TimeUnit delayTimeUnit) {
        return new StubServiceDelaySettingsBuilder(delay, delayTimeUnit, this);
    }

    public List<DelaySettings> getDelaySettings() {
        return Collections.unmodifiableList(this.delaySettings);
    }

    void addDelaySetting(DelaySettings delaySettings) {
        if (delaySettings != null) {
            this.delaySettings.add(delaySettings);
        }
    }

    StubServiceBuilder addDelaySetting(Request request, ResponseBuilder responseBuilder) {
        responseBuilder.addDelay().to(this).forRequest(request);
        return this;
    }
}

