/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.FieldMatcher;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import io.specto.hoverfly.junit.dsl.matchers.PlainTextFieldMatcher;
import io.specto.hoverfly.junit.dsl.matchers.RequestFieldMatcher;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RequestMatcherBuilder {
    private final StubServiceBuilder invoker;
    private final FieldMatcher method;
    private final FieldMatcher scheme;
    private final FieldMatcher destination;
    private final FieldMatcher path;
    private final MultivaluedHashMap<PlainTextFieldMatcher, PlainTextFieldMatcher> queryPatterns = new MultivaluedHashMap();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private FieldMatcher query = FieldMatcher.blankMatcher();
    private FieldMatcher body = FieldMatcher.blankMatcher();
    private boolean isFuzzyMatchedQuery;

    RequestMatcherBuilder(StubServiceBuilder invoker, FieldMatcher method, FieldMatcher scheme, FieldMatcher destination, FieldMatcher path) {
        this.invoker = invoker;
        this.method = method;
        this.scheme = scheme;
        this.destination = destination;
        this.path = path;
    }

    public RequestMatcherBuilder body(String body) {
        this.body = FieldMatcher.exactlyMatches(body);
        return this;
    }

    public RequestMatcherBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = FieldMatcher.exactlyMatches(httpBodyConverter.body());
        return this;
    }

    public RequestMatcherBuilder body(RequestFieldMatcher matcher) {
        this.body = matcher.getFieldMatcher();
        return this;
    }

    public RequestMatcherBuilder anyBody() {
        this.body = null;
        return this;
    }

    public RequestMatcherBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, Object ... values) {
        if (values.length == 0) {
            return this.queryParam(HoverflyMatchers.equalsTo(key), HoverflyMatchers.any());
        }
        for (Object value : values) {
            ((MultivaluedHashMap)this.queryPatterns).add(HoverflyMatchers.equalsTo(key), HoverflyMatchers.equalsTo(value));
        }
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, PlainTextFieldMatcher value) {
        return this.queryParam(HoverflyMatchers.equalsTo(key), value);
    }

    public RequestMatcherBuilder queryParam(PlainTextFieldMatcher key, String value) {
        return this.queryParam(key, HoverflyMatchers.equalsTo(value));
    }

    public RequestMatcherBuilder queryParam(PlainTextFieldMatcher key, PlainTextFieldMatcher value) {
        this.isFuzzyMatchedQuery = true;
        ((MultivaluedHashMap)this.queryPatterns).add(key, value);
        return this;
    }

    public RequestMatcherBuilder anyQueryParams() {
        this.query = null;
        return this;
    }

    public StubServiceBuilder willReturn(ResponseBuilder responseBuilder) {
        Request request = this.build();
        return this.invoker.addRequestResponsePair(new RequestResponsePair(request, responseBuilder.build())).addDelaySetting(request, responseBuilder);
    }

    private Request build() {
        if (!((MultivaluedHashMap)this.queryPatterns).isEmpty()) {
            String queryPatterns = ((MultivaluedHashMap)this.queryPatterns).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> this.encodeUrl(((PlainTextFieldMatcher)e.getKey()).getPattern()) + "=" + this.encodeUrl(v.getPattern()))).collect(Collectors.joining("&"));
            this.query = this.isFuzzyMatchedQuery ? FieldMatcher.wildCardMatches(queryPatterns) : FieldMatcher.exactlyMatches(queryPatterns);
        }
        return new Request(this.path, this.method, this.destination, this.scheme, this.query, this.body, this.headers);
    }

    private String encodeUrl(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static class MultivaluedHashMap<K, V> {
        private Map<K, List<V>> elements = new LinkedHashMap<K, List<V>>();

        private MultivaluedHashMap() {
        }

        private void add(K key, V value) {
            List<Object> values;
            if (this.elements.containsKey(key)) {
                values = this.elements.get(key);
            } else {
                values = new ArrayList();
                this.elements.put(key, values);
            }
            values.add(value);
        }

        private Set<Map.Entry<K, List<V>>> entrySet() {
            return this.elements.entrySet();
        }

        private boolean isEmpty() {
            return this.elements.isEmpty();
        }
    }
}

