/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.RemoteHoverflyConfig;

class RemoteHoverflyConfigBuilder
implements RemoteHoverflyConfig {
    private String host;
    private String scheme;
    private String authToken;
    private int adminPort = 8888;
    private int proxyPort = 8500;
    private String adminCertificate;
    private String proxyCaCertificate;
    private String destination;
    private boolean proxyLocalHost;

    RemoteHoverflyConfigBuilder() {
    }

    @Override
    public RemoteHoverflyConfig withAuthHeader() {
        this.authToken = System.getenv("HOVERFLY_AUTH_TOKEN");
        return this;
    }

    @Override
    public RemoteHoverflyConfig host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public RemoteHoverflyConfig withAuthHeader(String authToken) {
        this.authToken = authToken;
        return this;
    }

    @Override
    public RemoteHoverflyConfig withHttpsAdminEndpoint() {
        this.scheme = "https";
        this.adminPort = 443;
        return this;
    }

    @Override
    public HoverflyConfig adminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    @Override
    public HoverflyConfig proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Override
    public HoverflyConfig destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Override
    public HoverflyConfig proxyLocalHost() {
        this.proxyLocalHost = true;
        return this;
    }

    @Override
    public HoverflyConfig proxyCaCert(String proxyCaCert) {
        this.proxyCaCertificate = proxyCaCert;
        return this;
    }

    @Override
    public HoverflyConfiguration build() {
        HoverflyConfiguration configs = new HoverflyConfiguration(this.scheme, this.host, this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCertificate, this.authToken, this.adminCertificate);
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }
}

