/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.api;

import io.specto.hoverfly.junit.api.HoverflyClient;
import io.specto.hoverfly.junit.api.OkHttpHoverflyClient;

public class HoverflyClientBuilder {
    private String scheme = "http";
    private String host = "localhost";
    private int port = 8888;
    private String authToken = null;

    public HoverflyClientBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HoverflyClientBuilder host(String host) {
        this.host = host;
        return this;
    }

    public HoverflyClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    public HoverflyClientBuilder withAuthToken() {
        this.authToken = System.getenv("HOVERFLY_AUTH_TOKEN");
        return this;
    }

    public HoverflyClient build() {
        return new OkHttpHoverflyClient(this.scheme, this.host, this.port, this.authToken);
    }
}

