/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.FieldMatcher;
import io.specto.hoverfly.junit.core.model.RequestMatcher;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RequestMatcherBuilder {
    private final StubServiceBuilder invoker;
    private final FieldMatcher method;
    private final FieldMatcher scheme;
    private final FieldMatcher destination;
    private final FieldMatcher path;
    private final MultivaluedHashMap<String, String> queryParams = new MultivaluedHashMap();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private FieldMatcher body;

    private RequestMatcherBuilder(StubServiceBuilder invoker, String method, String scheme, String destination, String path) {
        this.invoker = invoker;
        this.method = FieldMatcher.fromString(method);
        this.scheme = FieldMatcher.fromString(scheme);
        this.destination = FieldMatcher.fromString(destination);
        this.path = FieldMatcher.fromString(path);
    }

    static RequestMatcherBuilder requestMatcherBuilder(StubServiceBuilder invoker, String method, String scheme, String destination, String path) {
        return new RequestMatcherBuilder(invoker, method, scheme, destination, path);
    }

    public RequestMatcherBuilder body(String body) {
        this.body = FieldMatcher.fromString(body);
        return this;
    }

    public RequestMatcherBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = FieldMatcher.fromString(httpBodyConverter.body());
        return this;
    }

    public RequestMatcherBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, Object ... values) {
        for (Object value : values) {
            ((MultivaluedHashMap)this.queryParams).add(key, value.toString());
        }
        return this;
    }

    public StubServiceBuilder willReturn(ResponseBuilder responseBuilder) {
        RequestMatcher requestMatcher = this.build();
        return this.invoker.addRequestResponsePair(new RequestResponsePair(requestMatcher, responseBuilder.build())).addDelaySetting(requestMatcher, responseBuilder);
    }

    private RequestMatcher build() {
        String query = ((MultivaluedHashMap)this.queryParams).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> this.encodeUrl((String)e.getKey()) + "=" + this.encodeUrl((String)v))).collect(Collectors.joining("&"));
        return new RequestMatcher(this.path, this.method, this.destination, this.scheme, FieldMatcher.fromString(query), this.body, this.headers);
    }

    private String encodeUrl(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static class MultivaluedHashMap<K, V> {
        private Map<K, List<V>> elements = new HashMap<K, List<V>>();

        private MultivaluedHashMap() {
        }

        private void add(K key, V value) {
            List<Object> values;
            if (this.elements.containsKey(key)) {
                values = this.elements.get(key);
            } else {
                values = new ArrayList();
                this.elements.put(key, values);
            }
            values.add(value);
        }

        private Set<Map.Entry<K, List<V>>> entrySet() {
            return this.elements.entrySet();
        }
    }
}

