/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.specto.hoverfly.junit.core.model.FieldMatcher;
import io.specto.hoverfly.junit.core.model.FieldMatcherDeserializer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RequestMatcher {
    @JsonDeserialize(using=FieldMatcherDeserializer.class)
    private final FieldMatcher path;
    @JsonDeserialize(using=FieldMatcherDeserializer.class)
    private final FieldMatcher method;
    @JsonDeserialize(using=FieldMatcherDeserializer.class)
    private final FieldMatcher destination;
    @JsonDeserialize(using=FieldMatcherDeserializer.class)
    private final FieldMatcher scheme;
    @JsonDeserialize(using=FieldMatcherDeserializer.class)
    private final FieldMatcher query;
    @JsonDeserialize(using=FieldMatcherDeserializer.class)
    private final FieldMatcher body;
    private final Map<String, List<String>> headers;
    private RequestType requestType;

    @Deprecated
    public RequestMatcher(String path, String method, String destination, String scheme, String query, String body, Map<String, List<String>> headers) {
        this.path = FieldMatcher.fromString(path);
        this.method = FieldMatcher.fromString(method);
        this.destination = FieldMatcher.fromString(destination);
        this.scheme = FieldMatcher.fromString(scheme);
        this.query = FieldMatcher.fromString(query);
        this.body = FieldMatcher.fromString(body);
        this.headers = headers;
    }

    @JsonCreator
    public RequestMatcher(@JsonProperty(value="path") FieldMatcher path, @JsonProperty(value="method") FieldMatcher method, @JsonProperty(value="destination") FieldMatcher destination, @JsonProperty(value="scheme") FieldMatcher scheme, @JsonProperty(value="query") FieldMatcher query, @JsonProperty(value="body") FieldMatcher body, @JsonProperty(value="headers") Map<String, List<String>> headers) {
        this.path = path;
        this.method = method;
        this.destination = destination;
        this.scheme = scheme;
        this.query = query;
        this.body = body;
        this.headers = headers;
    }

    public FieldMatcher getPath() {
        return this.path;
    }

    public FieldMatcher getMethod() {
        return this.method;
    }

    public FieldMatcher getDestination() {
        return this.destination;
    }

    public FieldMatcher getScheme() {
        return this.scheme;
    }

    public FieldMatcher getQuery() {
        return this.query;
    }

    public FieldMatcher getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.requestType == RequestType.RECORDING ? Collections.emptyMap() : this.headers;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[]{"requestType"});
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"requestType"});
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static enum RequestType {
        TEMPLATE,
        RECORDING;

    }

    static class Builder {
        private FieldMatcher path;
        private FieldMatcher method;
        private FieldMatcher destination;
        private FieldMatcher scheme;
        private FieldMatcher query;
        private FieldMatcher body;
        private Map<String, List<String>> headers;

        Builder() {
        }

        Builder path(FieldMatcher path) {
            this.path = path;
            return this;
        }

        Builder method(FieldMatcher method) {
            this.method = method;
            return this;
        }

        Builder destination(FieldMatcher destination) {
            this.destination = destination;
            return this;
        }

        Builder scheme(FieldMatcher scheme) {
            this.scheme = scheme;
            return this;
        }

        Builder query(FieldMatcher query) {
            this.query = query;
            return this;
        }

        Builder body(FieldMatcher body) {
            this.body = body;
            return this;
        }

        Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        RequestMatcher build() {
            return new RequestMatcher(this.path, this.method, this.destination, this.scheme, this.query, this.body, this.headers);
        }
    }
}

