/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.specto.hoverfly.junit.core.model.Response;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseDelaySettingsBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResponseBuilder {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String body = "";
    private int status = 200;
    private int delay;
    private TimeUnit delayTimeUnit;

    private ResponseBuilder() {
    }

    public static ResponseBuilder response() {
        return new ResponseBuilder();
    }

    public ResponseBuilder body(String body) {
        this.body = body;
        return this;
    }

    public ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    public ResponseBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    Response build() {
        return new Response(this.status, this.body, false, this.headers);
    }

    public ResponseBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = httpBodyConverter.body();
        this.header("Content-Type", httpBodyConverter.contentType());
        return this;
    }

    public ResponseBuilder withDelay(int delay, TimeUnit delayTimeUnit) {
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
        return this;
    }

    ResponseDelaySettingsBuilder addDelay() {
        return new ResponseDelaySettingsBuilder(this.delay, this.delayTimeUnit);
    }
}

