/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public interface HttpBodyConverter {
    public static HttpBodyConverter json(Object body) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return HttpBodyConverter.json(body, objectMapper);
    }

    public static HttpBodyConverter json(final Object body, final ObjectMapper objectMapper) {
        return new HttpBodyConverter(){

            @Override
            public String body() {
                try {
                    return objectMapper.writeValueAsString(body);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Cannot marshall: " + body, e);
                }
            }

            @Override
            public String contentType() {
                return "application/json";
            }
        };
    }

    public String body();

    public String contentType();
}

