/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.RequestMatcher;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class RequestMatcherBuilder {
    private static final String TEMPLATE = "template";
    private final StubServiceBuilder invoker;
    private final String method;
    private final String scheme;
    private final String destination;
    private final String path;
    private final MultivaluedMap<String, String> queryParams = new MultivaluedHashMap();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String body;

    private RequestMatcherBuilder(StubServiceBuilder invoker, String method, String scheme, String destination, String path) {
        this.invoker = invoker;
        this.method = method;
        this.scheme = scheme;
        this.destination = destination;
        this.path = path;
    }

    static RequestMatcherBuilder requestMatcherBuilder(StubServiceBuilder invoker, String method, String scheme, String destination, String path) {
        return new RequestMatcherBuilder(invoker, method, scheme, destination, path);
    }

    public RequestMatcherBuilder body(String body) {
        this.body = body;
        return this;
    }

    public RequestMatcherBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = httpBodyConverter.body();
        this.header("Content-Type", httpBodyConverter.contentType());
        return this;
    }

    public RequestMatcherBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, Object ... values) {
        for (Object value : values) {
            this.queryParams.add((Object)key, (Object)value.toString());
        }
        return this;
    }

    public StubServiceBuilder willReturn(ResponseBuilder responseBuilder) {
        return this.invoker.addRequestResponsePair(new RequestResponsePair(this.build(), responseBuilder.build()));
    }

    private RequestMatcher build() {
        String query = this.queryParams.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> this.encodeUrl((String)e.getKey()) + "=" + this.encodeUrl((String)v))).collect(Collectors.joining("&"));
        return new RequestMatcher(this.path, this.method, this.destination, this.scheme, query, this.body, this.headers, TEMPLATE);
    }

    private String encodeUrl(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

