/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.SystemConfig;
import io.specto.hoverfly.junit.core.SystemInfo;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;

class SystemConfigFactory {
    static final String DEFAULT_BINARY_NAME_FORMAT = "hoverfly_%s_%s%s";
    private final SystemInfo systemInfo = new SystemInfo();
    private HoverflyConfiguration configs;

    SystemConfigFactory() {
    }

    SystemConfigFactory(HoverflyConfiguration configs) {
        this.configs = configs;
    }

    SystemConfig createSystemConfig() {
        OsName osName;
        String binaryNameFormat = DEFAULT_BINARY_NAME_FORMAT;
        if (this.systemInfo.isOsWindows()) {
            osName = OsName.WINDOWS;
        } else if (this.systemInfo.isOsLinux()) {
            osName = OsName.LINUX;
        } else if (this.systemInfo.isOsMac()) {
            osName = OsName.OSX;
        } else {
            throw new UnsupportedOperationException(this.systemInfo.getOsName() + " is not currently supported");
        }
        ArchType archType = this.systemInfo.is64BitSystem() ? ArchType.ARCH_AMD64 : ArchType.ARCH_386;
        if (this.configs != null && this.configs.getBinaryNameFormat() != null) {
            binaryNameFormat = this.configs.getBinaryNameFormat();
        }
        return new SystemConfig(osName, archType, binaryNameFormat);
    }

    static enum ArchType {
        ARCH_AMD64("amd64"),
        ARCH_386("386");

        private final String name;

        private ArchType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    static enum OsName {
        OSX("OSX"),
        WINDOWS("windows"),
        LINUX("linux");

        private final String name;

        private OsName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

