/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.config.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.config.LocalMiddleware;
import io.specto.hoverfly.junit.core.config.LogLevel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHoverflyConfig
extends HoverflyConfig {
    private String sslCertificatePath;
    private String sslKeyPath;
    private boolean tlsVerificationDisabled;
    private boolean plainHttpTunneling;
    private LocalMiddleware localMiddleware;
    private String upstreamProxy;
    private Logger hoverflyLogger = LoggerFactory.getLogger((String)"hoverfly");
    private LogLevel logLevel;
    private List<String> commands = new LinkedList<String>();
    private String binaryLocation;

    public LocalHoverflyConfig sslCertificatePath(String sslCertificatePath) {
        this.sslCertificatePath = sslCertificatePath;
        return this;
    }

    public LocalHoverflyConfig sslKeyPath(String sslKeyPath) {
        this.sslKeyPath = sslKeyPath;
        return this;
    }

    public LocalHoverflyConfig localMiddleware(String binary, String path) {
        this.localMiddleware = new LocalMiddleware(binary, path);
        return this;
    }

    public LocalHoverflyConfig disableTlsVerification() {
        this.tlsVerificationDisabled = true;
        return this;
    }

    public LocalHoverflyConfig plainHttpTunneling() {
        this.plainHttpTunneling = true;
        return this;
    }

    public LocalHoverflyConfig upstreamProxy(InetSocketAddress proxyAddress) {
        this.upstreamProxy = proxyAddress.getHostString() + ":" + proxyAddress.getPort();
        return this;
    }

    public LocalHoverflyConfig upstreamProxy(String upstreamProxy) {
        this.upstreamProxy = upstreamProxy;
        return this;
    }

    public LocalHoverflyConfig logger(String loggerName) {
        this.hoverflyLogger = LoggerFactory.getLogger((String)loggerName);
        return this;
    }

    public LocalHoverflyConfig logToStdOut() {
        this.hoverflyLogger = null;
        return this;
    }

    public LocalHoverflyConfig logLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public LocalHoverflyConfig addCommands(String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
        return this;
    }

    @Override
    public HoverflyConfiguration build() {
        HoverflyConfiguration configs = new HoverflyConfiguration(this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCert, this.captureHeaders, this.webServer, this.hoverflyLogger, this.logLevel, this.statefulCapture, this.incrementalCapture, this.simulationPreprocessor);
        configs.setSslCertificatePath(this.sslCertificatePath);
        configs.setSslKeyPath(this.sslKeyPath);
        configs.setTlsVerificationDisabled(this.tlsVerificationDisabled);
        configs.setPlainHttpTunneling(this.plainHttpTunneling);
        configs.setLocalMiddleware(this.localMiddleware);
        configs.setUpstreamProxy(this.upstreamProxy);
        configs.setCommands(this.commands);
        configs.setBinaryLocation(this.binaryLocation);
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }

    public HoverflyConfig binaryLocation(String binaryLocation) {
        this.binaryLocation = binaryLocation;
        return this;
    }
}

