/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.api.view;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.specto.hoverfly.junit.api.view.DiffReport;
import io.specto.hoverfly.junit.api.view.SimpleRequestDefinitionView;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ResponseDiffForRequestView {
    private final SimpleRequestDefinitionView request;
    private final List<DiffReport> diffReports;

    @JsonCreator
    public ResponseDiffForRequestView(@JsonProperty(value="request") SimpleRequestDefinitionView request, @JsonProperty(value="diffReports") List<DiffReport> diffReports) {
        this.request = request;
        this.diffReports = diffReports;
    }

    public String createDiffMessage() {
        StringBuilder message = new StringBuilder().append("\nFor the request with the simple definition:\n" + this.getRequest().toString()).append("\n\nhave been recorded " + this.getDiffReports().size() + " diff(s):\n");
        for (int i = 0; i < this.getDiffReports().size(); ++i) {
            DiffReport diffReport = this.getDiffReports().get(i);
            message.append(String.format("\n%s. diff report at %s:\n", i + 1, diffReport.getTimestamp())).append(diffReport.createDiffMessage() + "\n");
        }
        return message.toString();
    }

    public SimpleRequestDefinitionView getRequest() {
        return this.request;
    }

    public List<DiffReport> getDiffReports() {
        return this.diffReports;
    }
}

