/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestFieldMatcher;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestMatcherBuilder {
    private StubServiceBuilder invoker;
    private final List<RequestFieldMatcher> method;
    private final List<RequestFieldMatcher> scheme;
    private final List<RequestFieldMatcher> destination;
    private final List<RequestFieldMatcher> path;
    private final Map<String, List<RequestFieldMatcher>> headers = new HashMap<String, List<RequestFieldMatcher>>();
    private final Map<String, String> requiresState = new HashMap<String, String>();
    private Map<String, List<RequestFieldMatcher>> query = new HashMap<String, List<RequestFieldMatcher>>();
    private List<RequestFieldMatcher> body = Collections.singletonList(RequestFieldMatcher.newExactMatcher(""));
    private List<RequestFieldMatcher> deprecatedQuery = Collections.singletonList(RequestFieldMatcher.newExactMatcher(""));

    RequestMatcherBuilder(StubServiceBuilder invoker, StubServiceBuilder.HttpMethod method, List<RequestFieldMatcher> scheme, List<RequestFieldMatcher> destination, List<RequestFieldMatcher> path) {
        this.invoker = invoker;
        this.method = method.getRequestFieldMatcher();
        this.scheme = scheme;
        this.destination = destination;
        this.path = path;
    }

    public RequestMatcherBuilder body(String body) {
        this.body = Collections.singletonList(RequestFieldMatcher.newExactMatcher(body));
        return this;
    }

    public RequestMatcherBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = Collections.singletonList(RequestFieldMatcher.newExactMatcher(httpBodyConverter.body()));
        return this;
    }

    public RequestMatcherBuilder body(RequestFieldMatcher matcher) {
        this.body = Collections.singletonList(matcher);
        return this;
    }

    public RequestMatcherBuilder anyBody() {
        this.body = null;
        return this;
    }

    public RequestMatcherBuilder header(String key, Object ... values) {
        if (values.length == 0) {
            this.headers.put(key, Collections.singletonList(HoverflyMatchers.any()));
        } else {
            this.headers.put(key, Collections.singletonList(RequestFieldMatcher.newExactMatcher(Arrays.stream(values).map(Object::toString).collect(Collectors.joining(";")))));
        }
        return this;
    }

    public RequestMatcherBuilder header(String key, RequestFieldMatcher matcher) {
        this.headers.put(key, Collections.singletonList(matcher));
        return this;
    }

    public RequestMatcherBuilder withState(String key, String value) {
        this.requiresState.put(key, value);
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, Object ... values) {
        if (values.length == 0) {
            this.query.put(key, Collections.singletonList(HoverflyMatchers.any()));
        } else {
            this.query.put(key, Collections.singletonList(RequestFieldMatcher.newExactMatcher(Arrays.stream(values).map(Object::toString).collect(Collectors.joining(";")))));
        }
        this.deprecatedQuery = null;
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, RequestFieldMatcher matcher) {
        this.query.put(key, Collections.singletonList(matcher));
        this.deprecatedQuery = null;
        return this;
    }

    public RequestMatcherBuilder anyQueryParams() {
        this.query = null;
        this.deprecatedQuery = null;
        return this;
    }

    public StubServiceBuilder willReturn(ResponseBuilder responseBuilder) {
        Request request = this.build();
        return this.invoker.addRequestResponsePair(new RequestResponsePair(request, responseBuilder.build())).addDelaySetting(request, responseBuilder);
    }

    public Request build() {
        return new Request(this.path, this.method, this.destination, this.scheme, this.query, this.deprecatedQuery, this.body, this.headers, this.requiresState);
    }
}

