/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.specto.hoverfly.junit.core.model.Simulation;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Optional;
import java.util.Scanner;

class HoverflyUtils {
    private static ObjectWriter OBJECT_WRITER = new ObjectMapper().writerFor(Simulation.class);

    HoverflyUtils() {
    }

    static void checkPortInUse(int port) {
        try {
            ServerSocket ignored = new ServerSocket(port, 1, InetAddress.getLoopbackAddress());
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Port is already in use: " + port);
        }
    }

    static URL findResourceOnClasspath(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Optional.ofNullable(classLoader.getResource(resourceName)).orElseThrow(() -> new IllegalArgumentException("Resource not found with name: " + resourceName));
    }

    static InputStream getClasspathResourceAsStream(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Optional.ofNullable(classLoader.getResourceAsStream(resourceName)).orElseThrow(() -> new IllegalArgumentException("Resource not found with name: " + resourceName));
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    static String writeSimulationAsString(Simulation simulation) {
        try {
            return OBJECT_WRITER.writeValueAsString((Object)simulation);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize simulation object", e);
        }
    }
}

