/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Optional;

class HoverflyUtils {
    HoverflyUtils() {
    }

    static void checkPortInUse(int port) {
        try {
            ServerSocket ignored = new ServerSocket(port, 1, InetAddress.getLoopbackAddress());
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Port is already in use: " + port);
        }
    }

    static URL findResourceOnClasspath(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Optional.ofNullable(classLoader.getResource(resourceName)).orElseThrow(() -> new IllegalArgumentException("Resource not found with name: " + resourceName));
    }
}

