/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoverflyMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyMetaData.class);
    private String schemaVersion = "v4";

    public HoverflyMetaData() {
    }

    @JsonCreator
    public HoverflyMetaData(@JsonProperty(value="schemaVersion") String schemaVersion) {
        this();
        this.schemaVersion = schemaVersion;
        if ("v1".equals(schemaVersion)) {
            LOGGER.info("Upgrading v1 schema version to v2");
            this.schemaVersion = "v2";
        }
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

