/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PendingWriteQueue;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PendingWriteQueueTest {
    @Test
    public void testRemoveAndWrite() {
        PendingWriteQueueTest.assertWrite((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                Assert.assertFalse((String)"Should not be writable anymore", (boolean)ctx.channel().isWritable());
                ChannelFuture future = this.queue.removeAndWrite();
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        PendingWriteQueueTest.assertQueueEmpty(queue);
                    }
                });
                super.flush(ctx);
            }
        }, 1);
    }

    @Test
    public void testRemoveAndWriteAll() {
        PendingWriteQueueTest.assertWrite((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                Assert.assertFalse((String)"Should not be writable anymore", (boolean)ctx.channel().isWritable());
                ChannelFuture future = this.queue.removeAndWriteAll();
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        PendingWriteQueueTest.assertQueueEmpty(queue);
                    }
                });
                super.flush(ctx);
            }
        }, 3);
    }

    @Test
    public void testRemoveAndFail() {
        PendingWriteQueueTest.assertWriteFails((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                this.queue.removeAndFail((Throwable)new TestException());
                super.flush(ctx);
            }
        }, 1);
    }

    @Test
    public void testRemoveAndFailAll() {
        PendingWriteQueueTest.assertWriteFails((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                this.queue.removeAndFailAll((Throwable)new TestException());
                super.flush(ctx);
            }
        }, 3);
    }

    @Test
    public void shouldFireChannelWritabilityChangedAfterRemoval() {
        final AtomicReference ctxRef = new AtomicReference();
        final AtomicReference queueRef = new AtomicReference();
        ByteBuf msg = Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                ctxRef.set(ctx);
                queueRef.set(new PendingWriteQueue(ctx));
            }

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                PendingWriteQueue queue = (PendingWriteQueue)queueRef.get();
                ByteBuf msg = (ByteBuf)queue.current();
                if (msg == null) {
                    return;
                }
                MatcherAssert.assertThat((Object)msg.refCnt(), (Matcher)Matchers.is((Object)1));
                queue.remove();
                MatcherAssert.assertThat((Object)msg.refCnt(), (Matcher)Matchers.is((Object)0));
            }
        }});
        channel.config().setWriteBufferLowWaterMark(1);
        channel.config().setWriteBufferHighWaterMark(3);
        PendingWriteQueue queue = (PendingWriteQueue)queueRef.get();
        queue.add((Object)msg, channel.newPromise());
        channel.finish();
        MatcherAssert.assertThat((Object)msg.refCnt(), (Matcher)Matchers.is((Object)0));
    }

    private static void assertWrite(ChannelHandler handler, int count) {
        int i;
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        channel.config().setWriteBufferLowWaterMark(1);
        channel.config().setWriteBufferHighWaterMark(3);
        Object[] buffers = new ByteBuf[count];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = buffer.retainedDuplicate();
        }
        Assert.assertTrue((boolean)channel.writeOutbound(buffers));
        Assert.assertTrue((boolean)channel.finish());
        channel.closeFuture().syncUninterruptibly();
        for (i = 0; i < buffers.length; ++i) {
            PendingWriteQueueTest.assertBuffer(channel, buffer);
        }
        buffer.release();
        Assert.assertNull((Object)channel.readOutbound());
    }

    private static void assertBuffer(EmbeddedChannel channel, ByteBuf buffer) {
        ByteBuf written = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)buffer, (Object)written);
        written.release();
    }

    private static void assertQueueEmpty(PendingWriteQueue queue) {
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((long)0L, (long)queue.bytes());
        Assert.assertNull((Object)queue.current());
        Assert.assertNull((Object)queue.removeAndWrite());
        Assert.assertNull((Object)queue.removeAndWriteAll());
    }

    private static void assertWriteFails(ChannelHandler handler, int count) {
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        Object[] buffers = new ByteBuf[count];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = buffer.retainedDuplicate();
        }
        try {
            Assert.assertFalse((boolean)channel.writeOutbound(buffers));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof TestException));
        }
        Assert.assertFalse((boolean)channel.finish());
        channel.closeFuture().syncUninterruptibly();
        buffer.release();
        Assert.assertNull((Object)channel.readOutbound());
    }

    private static EmbeddedChannel newChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new ChannelHandlerAdapter(){}});
    }

    @Test
    public void testRemoveAndFailAllReentrantFailAll() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        ChannelPromise promise = channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                queue.removeAndFailAll((Throwable)new IllegalStateException());
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        queue.add((Object)2L, promise2);
        queue.removeAndFailAll((Throwable)new Exception());
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertFalse((boolean)promise.isSuccess());
        Assert.assertTrue((boolean)promise2.isDone());
        Assert.assertFalse((boolean)promise2.isSuccess());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRemoveAndWriteAllReentrantWrite() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ctx.writeAndFlush(msg, promise);
            }
        }, new ChannelOutboundHandlerAdapter()});
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().lastContext());
        ChannelPromise promise = channel.newPromise();
        final ChannelPromise promise3 = channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                queue.add((Object)3L, promise3);
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        queue.add((Object)2L, promise2);
        queue.removeAndWriteAll();
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertTrue((boolean)promise.isSuccess());
        Assert.assertTrue((boolean)promise2.isDone());
        Assert.assertTrue((boolean)promise2.isSuccess());
        Assert.assertTrue((boolean)promise3.isDone());
        Assert.assertTrue((boolean)promise3.isSuccess());
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertEquals((Object)2L, (Object)channel.readOutbound());
        Assert.assertEquals((Object)3L, (Object)channel.readOutbound());
    }

    @Test
    public void testRemoveAndWriteAllWithVoidPromise() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ctx.writeAndFlush(msg, promise);
            }
        }, new ChannelOutboundHandlerAdapter()});
        PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().lastContext());
        ChannelPromise promise = channel.newPromise();
        queue.add((Object)1L, promise);
        queue.add((Object)2L, channel.voidPromise());
        queue.removeAndWriteAll();
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertTrue((boolean)promise.isSuccess());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertEquals((Object)2L, (Object)channel.readOutbound());
    }

    @Test
    public void testRemoveAndFailAllReentrantWrite() {
        final List failOrder = Collections.synchronizedList(new ArrayList());
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        ChannelPromise promise = channel.newPromise();
        final ChannelPromise promise3 = channel.newPromise();
        promise3.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                failOrder.add(3);
            }
        });
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                failOrder.add(1);
                queue.add((Object)3L, promise3);
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        promise2.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                failOrder.add(2);
            }
        });
        queue.add((Object)2L, promise2);
        queue.removeAndFailAll((Throwable)new Exception());
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertFalse((boolean)promise.isSuccess());
        Assert.assertTrue((boolean)promise2.isDone());
        Assert.assertFalse((boolean)promise2.isSuccess());
        Assert.assertTrue((boolean)promise3.isDone());
        Assert.assertFalse((boolean)promise3.isSuccess());
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertEquals((long)1L, (long)((Integer)failOrder.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)failOrder.get(1)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)failOrder.get(2)).intValue());
    }

    @Test
    public void testRemoveAndWriteAllReentrance() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        ChannelPromise promise = channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                queue.removeAndWriteAll();
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        queue.add((Object)2L, promise2);
        queue.removeAndWriteAll();
        channel.flush();
        Assert.assertTrue((boolean)promise.isSuccess());
        Assert.assertTrue((boolean)promise2.isSuccess());
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertEquals((Object)2L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testCloseChannelOnCreation() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        ChannelHandlerContext context = channel.pipeline().firstContext();
        channel.close().syncUninterruptibly();
        PendingWriteQueue queue = new PendingWriteQueue(context);
        IllegalStateException ex = new IllegalStateException();
        ChannelPromise promise = channel.newPromise();
        queue.add((Object)1L, promise);
        queue.removeAndFailAll((Throwable)ex);
        Assert.assertSame((Object)ex, (Object)promise.cause());
    }

    private static final class TestException
    extends Exception {
        private static final long serialVersionUID = -9018570103039458401L;

        private TestException() {
        }
    }

    private static class TestHandler
    extends ChannelDuplexHandler {
        protected PendingWriteQueue queue;
        private int expectedSize;

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            PendingWriteQueueTest.assertQueueEmpty(this.queue);
            Assert.assertTrue((String)"Should be writable", (boolean)ctx.channel().isWritable());
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.queue.add(msg, promise);
            Assert.assertFalse((boolean)this.queue.isEmpty());
            Assert.assertEquals((long)(++this.expectedSize), (long)this.queue.size());
            Assert.assertNotNull((Object)this.queue.current());
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.queue = new PendingWriteQueue(ctx);
        }
    }
}

