/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelId;
import io.netty.channel.DefaultChannelId;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DefaultChannelIdTest {
    @Test
    public void testShortText() {
        String text = DefaultChannelId.newInstance().asShortText();
        Assert.assertTrue((boolean)text.matches("^[0-9a-f]{8}$"));
    }

    @Test
    public void testLongText() {
        String text = DefaultChannelId.newInstance().asLongText();
        Assert.assertTrue((boolean)text.matches("^[0-9a-f]{16}-[0-9a-f]{8}-[0-9a-f]{8}-[0-9a-f]{16}-[0-9a-f]{8}$"));
    }

    @Test
    public void testIdempotentMachineId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        String b = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Object)b));
    }

    @Test
    public void testIdempotentProcessId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        String b = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Object)b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws Exception {
        ChannelId b;
        DefaultChannelId a = DefaultChannelId.newInstance();
        ByteBuf buf = Unpooled.buffer();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            out.writeObject(a);
            out.flush();
        }
        finally {
            out.close();
        }
        ObjectInputStream in = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));
        try {
            b = (ChannelId)in.readObject();
        }
        finally {
            in.close();
        }
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Object)b));
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)b))));
        MatcherAssert.assertThat((Object)a.asLongText(), (Matcher)CoreMatchers.is((Object)b.asLongText()));
    }
}

