/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultChannelPipelineTailTest {
    private static EventLoopGroup GROUP;

    @BeforeClass
    public static void init() {
        GROUP = new DefaultEventLoopGroup(1);
    }

    @AfterClass
    public static void destroy() {
        GROUP.shutdownGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundChannelActive() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundChannelActive() {
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        try {
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            channel.close();
        }
    }

    @Test
    public void testOnUnhandledInboundChannelInactive() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundChannelInactive() {
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        channel.close().syncUninterruptibly();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundException() throws Exception {
        final AtomicReference causeRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundException(Throwable cause) {
                causeRef.set(cause);
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        try {
            IOException ex = new IOException("testOnUnhandledInboundException");
            channel.pipeline().fireExceptionCaught((Throwable)ex);
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assert.assertSame((Object)ex, causeRef.get());
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundMessage() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundMessage(Object msg) {
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        try {
            channel.pipeline().fireChannelRead((Object)"testOnUnhandledInboundMessage");
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundReadComplete() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundReadComplete() {
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        try {
            channel.pipeline().fireChannelReadComplete();
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundUserEventTriggered() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundUserEventTriggered(Object evt) {
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        try {
            channel.pipeline().fireUserEventTriggered((Object)"testOnUnhandledInboundUserEventTriggered");
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundWritabilityChanged() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MyChannel myChannel = new MyChannel(){

            @Override
            protected void onUnhandledInboundWritabilityChanged() {
                latch.countDown();
            }
        };
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory((ChannelFactory)new MyChannelFactory(myChannel))).group(GROUP)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).remoteAddress((SocketAddress)new InetSocketAddress(0));
        Channel channel = bootstrap.connect().sync().channel();
        try {
            channel.pipeline().fireChannelWritabilityChanged();
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            channel.close();
        }
    }

    private static abstract class MyChannel
    extends AbstractChannel {
        private static final ChannelMetadata METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
        private boolean active;
        private boolean closed;

        protected MyChannel() {
            super(null);
        }

        protected DefaultChannelPipeline newChannelPipeline() {
            return new MyChannelPipeline((Channel)this);
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public boolean isActive() {
            return this.isOpen() && this.active;
        }

        public ChannelMetadata metadata() {
            return METADATA;
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new MyUnsafe();
        }

        protected boolean isCompatible(EventLoop loop) {
            return true;
        }

        protected SocketAddress localAddress0() {
            return null;
        }

        protected SocketAddress remoteAddress0() {
            return null;
        }

        protected void doBind(SocketAddress localAddress) throws Exception {
        }

        protected void doDisconnect() throws Exception {
        }

        protected void doClose() throws Exception {
            this.closed = true;
        }

        protected void doBeginRead() throws Exception {
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
            throw new IOException();
        }

        protected void onUnhandledInboundChannelActive() {
        }

        protected void onUnhandledInboundChannelInactive() {
        }

        protected void onUnhandledInboundException(Throwable cause) {
        }

        protected void onUnhandledInboundMessage(Object msg) {
        }

        protected void onUnhandledInboundReadComplete() {
        }

        protected void onUnhandledInboundUserEventTriggered(Object evt) {
        }

        protected void onUnhandledInboundWritabilityChanged() {
        }

        private class MyChannelPipeline
        extends DefaultChannelPipeline {
            MyChannelPipeline(Channel channel) {
                super(channel);
            }

            protected void onUnhandledInboundChannelActive() {
                MyChannel.this.onUnhandledInboundChannelActive();
            }

            protected void onUnhandledInboundChannelInactive() {
                MyChannel.this.onUnhandledInboundChannelInactive();
            }

            protected void onUnhandledInboundException(Throwable cause) {
                MyChannel.this.onUnhandledInboundException(cause);
            }

            protected void onUnhandledInboundMessage(Object msg) {
                MyChannel.this.onUnhandledInboundMessage(msg);
            }

            protected void onUnhandledInboundChannelReadComplete() {
                MyChannel.this.onUnhandledInboundReadComplete();
            }

            protected void onUnhandledInboundUserEventTriggered(Object evt) {
                MyChannel.this.onUnhandledInboundUserEventTriggered(evt);
            }

            protected void onUnhandledChannelWritabilityChanged() {
                MyChannel.this.onUnhandledInboundWritabilityChanged();
            }
        }

        private class MyUnsafe
        extends AbstractChannel.AbstractUnsafe {
            private MyUnsafe() {
                super((AbstractChannel)MyChannel.this);
            }

            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                if (!this.ensureOpen(promise)) {
                    return;
                }
                if (!MyChannel.this.active) {
                    MyChannel.this.active = true;
                    MyChannel.this.pipeline().fireChannelActive();
                }
                promise.setSuccess();
            }
        }
    }

    private static class MyChannelFactory
    implements ChannelFactory<MyChannel> {
        private final MyChannel channel;

        MyChannelFactory(MyChannel channel) {
            this.channel = channel;
        }

        public MyChannel newChannel() {
            return this.channel;
        }
    }
}

