/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.AbstractNioChannelTest;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import org.junit.Assert;
import org.junit.Test;

public class NioDatagramChannelTest
extends AbstractNioChannelTest<NioDatagramChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindMultiple() throws Exception {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            for (int i = 0; i < 100; ++i) {
                Bootstrap udpBootstrap = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                    }
                });
                DatagramChannel datagramChannel = (DatagramChannel)udpBootstrap.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
                channelGroup.add((Channel)datagramChannel);
            }
            Assert.assertEquals((long)100L, (long)channelGroup.size());
        }
        finally {
            channelGroup.close().sync();
            group.shutdownGracefully().sync();
        }
    }

    @Override
    protected NioDatagramChannel newNioChannel() {
        return new NioDatagramChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioDatagramChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.TCP_NODELAY;
    }
}

