/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFileRegionTest {
    private static final byte[] data = new byte[0xA00000];

    private static File newFile() throws IOException {
        File file = File.createTempFile("netty-", ".tmp");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.close();
        return file;
    }

    @Test
    public void testCreateFromFile() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        try {
            DefaultFileRegionTest.testFileRegion((FileRegion)new DefaultFileRegion(file, 0L, (long)data.length));
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testCreateFromFileChannel() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            DefaultFileRegionTest.testFileRegion((FileRegion)new DefaultFileRegion(randomAccessFile.getChannel(), 0L, (long)data.length));
        }
        finally {
            randomAccessFile.close();
            file.delete();
        }
    }

    private static void testFileRegion(FileRegion region) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(outputStream);
        try {
            Assert.assertEquals((long)data.length, (long)region.count());
            Assert.assertEquals((long)0L, (long)region.transferred());
            Assert.assertEquals((long)data.length, (long)region.transferTo(channel, 0L));
            Assert.assertEquals((long)data.length, (long)region.count());
            Assert.assertEquals((long)data.length, (long)region.transferred());
            Assert.assertArrayEquals((byte[])data, (byte[])outputStream.toByteArray());
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncated() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(outputStream);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            DefaultFileRegion region = new DefaultFileRegion(randomAccessFile.getChannel(), 0L, (long)data.length);
            randomAccessFile.getChannel().truncate(data.length - 1024);
            Assert.assertEquals((long)data.length, (long)region.count());
            Assert.assertEquals((long)0L, (long)region.transferred());
            Assert.assertEquals((long)(data.length - 1024), (long)region.transferTo(channel, 0L));
            Assert.assertEquals((long)data.length, (long)region.count());
            Assert.assertEquals((long)(data.length - 1024), (long)region.transferred());
            try {
                region.transferTo(channel, (long)(data.length - 1024));
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            channel.close();
            randomAccessFile.close();
            file.delete();
        }
    }

    static {
        PlatformDependent.threadLocalRandom().nextBytes(data);
    }
}

