/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolTestUtils;
import io.netty.channel.pool.CountingChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SimpleChannelPoolTest {
    @Test
    public void testAcquire() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).sync().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, (ChannelPoolHandler)handler);
        Channel channel = (Channel)pool.acquire().sync().getNow();
        pool.release(channel).syncUninterruptibly();
        Channel channel2 = (Channel)pool.acquire().sync().getNow();
        Assert.assertSame((Object)channel, (Object)channel2);
        Assert.assertEquals((long)1L, (long)handler.channelCount());
        pool.release(channel2).syncUninterruptibly();
        try {
            pool.release(channel2).syncUninterruptibly();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertFalse((boolean)channel.isActive());
        }
        Assert.assertEquals((long)2L, (long)handler.acquiredCount());
        Assert.assertEquals((long)2L, (long)handler.releasedCount());
        sc.close().sync();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testBoundedChannelPoolSegment() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).sync().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, handler, ChannelHealthChecker.ACTIVE){
            private final Queue<Channel> queue;
            {
                this.queue = new LinkedBlockingQueue<Channel>(1);
            }

            protected Channel pollChannel() {
                return this.queue.poll();
            }

            protected boolean offerChannel(Channel ch) {
                return this.queue.offer(ch);
            }
        };
        Channel channel = (Channel)pool.acquire().sync().getNow();
        Channel channel2 = (Channel)pool.acquire().sync().getNow();
        pool.release(channel).syncUninterruptibly().getNow();
        try {
            pool.release(channel2).syncUninterruptibly();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        channel2.close().sync();
        Assert.assertEquals((long)2L, (long)handler.channelCount());
        Assert.assertEquals((long)2L, (long)handler.acquiredCount());
        Assert.assertEquals((long)1L, (long)handler.releasedCount());
        sc.close().sync();
        channel.close().sync();
        channel2.close().sync();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testUnhealthyChannelIsNotOffered() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, (ChannelPoolHandler)handler);
        Channel channel1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        pool.release(channel1).syncUninterruptibly();
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assert.assertSame((Object)channel1, (Object)channel2);
        channel1.close().syncUninterruptibly();
        pool.release(channel1).syncUninterruptibly();
        Channel channel3 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assert.assertNotSame((Object)channel1, (Object)channel3);
        sc.close().syncUninterruptibly();
        channel3.close().syncUninterruptibly();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testUnhealthyChannelIsOfferedWhenNoHealthCheckRequested() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, false);
        Channel channel1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        channel1.close().syncUninterruptibly();
        Future releaseFuture = pool.release(channel1, channel1.eventLoop().newPromise()).syncUninterruptibly();
        Assert.assertThat((Object)releaseFuture.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assert.assertNotSame((Object)channel1, (Object)channel2);
        sc.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testBootstrap() {
        SimpleChannelPool pool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler());
        try {
            Assert.assertNotNull((Object)pool.bootstrap());
        }
        finally {
            pool.close();
        }
    }

    @Test
    public void testHandler() {
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)handler);
        try {
            Assert.assertSame((Object)handler, (Object)pool.handler());
        }
        finally {
            pool.close();
        }
    }

    @Test
    public void testHealthChecker() {
        ChannelHealthChecker healthChecker = ChannelHealthChecker.ACTIVE;
        SimpleChannelPool pool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler(), healthChecker);
        try {
            Assert.assertSame((Object)healthChecker, (Object)pool.healthChecker());
        }
        finally {
            pool.close();
        }
    }

    @Test
    public void testReleaseHealthCheck() {
        SimpleChannelPool healthCheckOnReleasePool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler(), ChannelHealthChecker.ACTIVE, true);
        try {
            Assert.assertTrue((boolean)healthCheckOnReleasePool.releaseHealthCheck());
        }
        finally {
            healthCheckOnReleasePool.close();
        }
        SimpleChannelPool noHealthCheckOnReleasePool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler(), ChannelHealthChecker.ACTIVE, false);
        try {
            Assert.assertFalse((boolean)noHealthCheckOnReleasePool.releaseHealthCheck());
        }
        finally {
            noHealthCheckOnReleasePool.close();
        }
    }

    @Test
    public void testCloseAsync() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).remoteAddress((SocketAddress)addr);
        SimpleChannelPool pool = new SimpleChannelPool(bootstrap, (ChannelPoolHandler)new CountingChannelPoolHandler());
        Channel ch1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Channel ch2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        pool.release(ch1).get(1L, TimeUnit.SECONDS);
        pool.release(ch2).get(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)ch1.isOpen());
        Assert.assertTrue((boolean)ch2.isOpen());
        pool.closeAsync().get(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)ch1.isOpen());
        Assert.assertFalse((boolean)ch2.isOpen());
        sc.close().sync();
        pool.close();
        group.shutdownGracefully();
    }
}

