/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class FixedChannelPoolMapDeadlockTest {
    private static final NoopHandler NOOP_HANDLER = new NoopHandler();

    @Test
    public void testDeadlockOnAcquire() throws Exception {
        DefaultEventLoop threadA1 = new DefaultEventLoop();
        Bootstrap bootstrapA1 = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)threadA1)).localAddress((SocketAddress)new LocalAddress("A1"));
        DefaultEventLoop threadA2 = new DefaultEventLoop();
        Bootstrap bootstrapA2 = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)threadA2)).localAddress((SocketAddress)new LocalAddress("A2"));
        DefaultEventLoop threadB1 = new DefaultEventLoop();
        Bootstrap bootstrapB1 = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)threadB1)).localAddress((SocketAddress)new LocalAddress("B1"));
        DefaultEventLoop threadB2 = new DefaultEventLoop();
        Bootstrap bootstrapB2 = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)threadB2)).localAddress((SocketAddress)new LocalAddress("B2"));
        FixedChannelPool poolA1 = new FixedChannelPool(bootstrapA1, (ChannelPoolHandler)NOOP_HANDLER, 1);
        FixedChannelPool poolA2 = new FixedChannelPool(bootstrapB2, (ChannelPoolHandler)NOOP_HANDLER, 1);
        FixedChannelPool poolB1 = new FixedChannelPool(bootstrapB1, (ChannelPoolHandler)NOOP_HANDLER, 1);
        FixedChannelPool poolB2 = new FixedChannelPool(bootstrapA2, (ChannelPoolHandler)NOOP_HANDLER, 1);
        CyclicBarrier arrivalBarrier = new CyclicBarrier(4);
        CyclicBarrier releaseBarrier = new CyclicBarrier(3);
        AbstractChannelPoolMap<String, FixedChannelPool> channelPoolMap = new AbstractChannelPoolMap<String, FixedChannelPool>((EventLoop)threadA1, arrivalBarrier, poolA1, (EventLoop)threadA2, releaseBarrier, poolA2, (EventLoop)threadB1, poolB1, (EventLoop)threadB2, poolB2){
            final /* synthetic */ EventLoop val$threadA1;
            final /* synthetic */ CyclicBarrier val$arrivalBarrier;
            final /* synthetic */ FixedChannelPool val$poolA1;
            final /* synthetic */ EventLoop val$threadA2;
            final /* synthetic */ CyclicBarrier val$releaseBarrier;
            final /* synthetic */ FixedChannelPool val$poolA2;
            final /* synthetic */ EventLoop val$threadB1;
            final /* synthetic */ FixedChannelPool val$poolB1;
            final /* synthetic */ EventLoop val$threadB2;
            final /* synthetic */ FixedChannelPool val$poolB2;
            {
                this.val$threadA1 = eventLoop;
                this.val$arrivalBarrier = cyclicBarrier;
                this.val$poolA1 = fixedChannelPool;
                this.val$threadA2 = eventLoop2;
                this.val$releaseBarrier = cyclicBarrier2;
                this.val$poolA2 = fixedChannelPool2;
                this.val$threadB1 = eventLoop3;
                this.val$poolB1 = fixedChannelPool3;
                this.val$threadB2 = eventLoop4;
                this.val$poolB2 = fixedChannelPool4;
            }

            protected FixedChannelPool newPool(String key) {
                if ("A".equals(key)) {
                    if (this.val$threadA1.inEventLoop()) {
                        FixedChannelPoolMapDeadlockTest.await(this.val$arrivalBarrier);
                        return this.val$poolA1;
                    }
                    if (this.val$threadA2.inEventLoop()) {
                        FixedChannelPoolMapDeadlockTest.await(this.val$arrivalBarrier);
                        FixedChannelPoolMapDeadlockTest.await(this.val$releaseBarrier);
                        return this.val$poolA2;
                    }
                } else if ("B".equals(key)) {
                    if (this.val$threadB1.inEventLoop()) {
                        FixedChannelPoolMapDeadlockTest.await(this.val$arrivalBarrier);
                        return this.val$poolB1;
                    }
                    if (this.val$threadB2.inEventLoop()) {
                        FixedChannelPoolMapDeadlockTest.await(this.val$arrivalBarrier);
                        FixedChannelPoolMapDeadlockTest.await(this.val$releaseBarrier);
                        return this.val$poolB2;
                    }
                }
                throw new AssertionError((Object)("Unexpected key=" + key + " or thread=" + Thread.currentThread().getName()));
            }
        };
        Future futureA1 = threadA1.submit((Callable)new Callable<FixedChannelPool>((AbstractChannelPoolMap)channelPoolMap){
            final /* synthetic */ AbstractChannelPoolMap val$channelPoolMap;
            {
                this.val$channelPoolMap = abstractChannelPoolMap;
            }

            @Override
            public FixedChannelPool call() throws Exception {
                return (FixedChannelPool)this.val$channelPoolMap.get((Object)"A");
            }
        });
        Future futureA2 = threadA2.submit((Callable)new Callable<FixedChannelPool>((AbstractChannelPoolMap)channelPoolMap){
            final /* synthetic */ AbstractChannelPoolMap val$channelPoolMap;
            {
                this.val$channelPoolMap = abstractChannelPoolMap;
            }

            @Override
            public FixedChannelPool call() throws Exception {
                return (FixedChannelPool)this.val$channelPoolMap.get((Object)"A");
            }
        });
        Future futureB1 = threadB1.submit((Callable)new Callable<FixedChannelPool>((AbstractChannelPoolMap)channelPoolMap){
            final /* synthetic */ AbstractChannelPoolMap val$channelPoolMap;
            {
                this.val$channelPoolMap = abstractChannelPoolMap;
            }

            @Override
            public FixedChannelPool call() throws Exception {
                return (FixedChannelPool)this.val$channelPoolMap.get((Object)"B");
            }
        });
        Future futureB2 = threadB2.submit((Callable)new Callable<FixedChannelPool>((AbstractChannelPoolMap)channelPoolMap){
            final /* synthetic */ AbstractChannelPoolMap val$channelPoolMap;
            {
                this.val$channelPoolMap = abstractChannelPoolMap;
            }

            @Override
            public FixedChannelPool call() throws Exception {
                return (FixedChannelPool)this.val$channelPoolMap.get((Object)"B");
            }
        });
        try {
            Assert.assertSame((Object)poolA1, (Object)futureA1.get(1L, TimeUnit.SECONDS));
            Assert.assertSame((Object)poolB1, (Object)futureB1.get(1L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            FixedChannelPoolMapDeadlockTest.shutdown(new EventLoop[]{threadA1, threadA2, threadB1, threadB2});
            throw e;
        }
        FixedChannelPoolMapDeadlockTest.await(releaseBarrier);
        try {
            Assert.assertSame((Object)poolA1, (Object)futureA2.get(1L, TimeUnit.SECONDS));
            Assert.assertSame((Object)poolB1, (Object)futureB2.get(1L, TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            try {
                throw new AssertionError((Object)e);
            }
            catch (Throwable throwable) {
                poolA1.close();
                poolA2.close();
                poolB1.close();
                poolB2.close();
                channelPoolMap.close();
                FixedChannelPoolMapDeadlockTest.shutdown(new EventLoop[]{threadA1, threadA2, threadB1, threadB2});
                throw throwable;
            }
        }
        poolA1.close();
        poolA2.close();
        poolB1.close();
        poolB2.close();
        channelPoolMap.close();
        FixedChannelPoolMapDeadlockTest.shutdown(new EventLoop[]{threadA1, threadA2, threadB1, threadB2});
    }

    @Test
    public void testDeadlockOnRemove() throws Exception {
        DefaultEventLoop thread1 = new DefaultEventLoop();
        Bootstrap bootstrap1 = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)thread1)).localAddress((SocketAddress)new LocalAddress("#1"));
        DefaultEventLoop thread2 = new DefaultEventLoop();
        Bootstrap bootstrap2 = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)thread2)).localAddress((SocketAddress)new LocalAddress("#2"));
        final FixedChannelPool pool1 = new FixedChannelPool(bootstrap2, (ChannelPoolHandler)NOOP_HANDLER, 1);
        final FixedChannelPool pool2 = new FixedChannelPool(bootstrap1, (ChannelPoolHandler)NOOP_HANDLER, 1);
        AbstractChannelPoolMap<String, FixedChannelPool> channelPoolMap = new AbstractChannelPoolMap<String, FixedChannelPool>(){

            protected FixedChannelPool newPool(String key) {
                if ("#1".equals(key)) {
                    return pool1;
                }
                if ("#2".equals(key)) {
                    return pool2;
                }
                throw new AssertionError((Object)("Unexpected key=" + key));
            }
        };
        Assert.assertSame((Object)pool1, (Object)channelPoolMap.get((Object)"#1"));
        Assert.assertSame((Object)pool2, (Object)channelPoolMap.get((Object)"#2"));
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Future future1 = thread1.submit(new Runnable((AbstractChannelPoolMap)channelPoolMap){
            final /* synthetic */ AbstractChannelPoolMap val$channelPoolMap;
            {
                this.val$channelPoolMap = abstractChannelPoolMap;
            }

            @Override
            public void run() {
                FixedChannelPoolMapDeadlockTest.await(barrier);
                this.val$channelPoolMap.remove((Object)"#1");
            }
        });
        Future future2 = thread2.submit(new Runnable((AbstractChannelPoolMap)channelPoolMap){
            final /* synthetic */ AbstractChannelPoolMap val$channelPoolMap;
            {
                this.val$channelPoolMap = abstractChannelPoolMap;
            }

            @Override
            public void run() {
                FixedChannelPoolMapDeadlockTest.await(barrier);
                this.val$channelPoolMap.remove((Object)"#2");
            }
        });
        try {
            future1.get(1L, TimeUnit.SECONDS);
            future2.get(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            try {
                throw new AssertionError((Object)e);
            }
            catch (Throwable throwable) {
                pool1.close();
                pool2.close();
                channelPoolMap.close();
                FixedChannelPoolMapDeadlockTest.shutdown(new EventLoop[]{thread1, thread2});
                throw throwable;
            }
        }
        pool1.close();
        pool2.close();
        channelPoolMap.close();
        FixedChannelPoolMapDeadlockTest.shutdown(new EventLoop[]{thread1, thread2});
    }

    private static void await(CyclicBarrier barrier) {
        try {
            barrier.await(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void shutdown(EventLoop ... eventLoops) {
        for (EventLoop eventLoop : eventLoops) {
            eventLoop.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
    }

    private static class NoopHandler
    extends AbstractChannelPoolHandler {
        private NoopHandler() {
        }

        public void channelCreated(Channel ch) throws Exception {
        }
    }
}

