/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import org.junit.Assert;
import org.junit.Test;

public class CombinedChannelDuplexHandlerTest {
    private static final Object MSG = new Object();
    private static final SocketAddress ADDRESS = new InetSocketAddress(0);

    @Test(expected=IllegalStateException.class)
    public void testInboundRemoveBeforeAdded() {
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
        handler.removeInboundHandler();
    }

    @Test(expected=IllegalStateException.class)
    public void testOutboundRemoveBeforeAdded() {
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
        handler.removeOutboundHandler();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInboundHandlerImplementsOutboundHandler() {
        new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelDuplexHandler(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutboundHandlerImplementsInboundHandler() {
        new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelDuplexHandler());
    }

    @Test(expected=IllegalStateException.class)
    public void testInitNotCalledBeforeAdded() throws Exception {
        CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler> handler = new CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler>(){};
        handler.handlerAdded(null);
    }

    @Test
    public void testExceptionCaughtBothCombinedHandlers() {
        final Exception exception = new Exception();
        final ArrayDeque queue = new ArrayDeque();
        ChannelInboundHandlerAdapter inboundHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Assert.assertSame((Object)exception, (Object)cause);
                queue.add(this);
                ctx.fireExceptionCaught(cause);
            }
        };
        ChannelOutboundHandlerAdapter outboundHandler = new ChannelOutboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Assert.assertSame((Object)exception, (Object)cause);
                queue.add(this);
                ctx.fireExceptionCaught(cause);
            }
        };
        ChannelInboundHandlerAdapter lastHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Assert.assertSame((Object)exception, (Object)cause);
                queue.add(this);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CombinedChannelDuplexHandler((ChannelInboundHandler)inboundHandler, (ChannelOutboundHandler)outboundHandler), lastHandler});
        channel.pipeline().fireExceptionCaught((Throwable)exception);
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertSame((Object)inboundHandler, queue.poll());
        Assert.assertSame((Object)outboundHandler, queue.poll());
        Assert.assertSame((Object)lastHandler, queue.poll());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testInboundEvents() {
        final ArrayDeque queue = new ArrayDeque();
        ChannelInboundHandlerAdapter inboundHandler = new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.HANDLER_ADDED);
            }

            public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.HANDLER_REMOVED);
            }

            public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.REGISTERED);
            }

            public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.UNREGISTERED);
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.ACTIVE);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.INACTIVE);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                queue.add(Event.CHANNEL_READ);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.CHANNEL_READ_COMPLETE);
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                queue.add(Event.USER_EVENT_TRIGGERED);
            }

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.CHANNEL_WRITABILITY_CHANGED);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                queue.add(Event.EXCEPTION_CAUGHT);
            }
        };
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)inboundHandler, (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        channel.pipeline().fireChannelWritabilityChanged();
        channel.pipeline().fireUserEventTriggered(MSG);
        channel.pipeline().fireChannelRead(MSG);
        channel.pipeline().fireChannelReadComplete();
        Assert.assertEquals((Object)((Object)Event.HANDLER_ADDED), queue.poll());
        Assert.assertEquals((Object)((Object)Event.REGISTERED), queue.poll());
        Assert.assertEquals((Object)((Object)Event.ACTIVE), queue.poll());
        Assert.assertEquals((Object)((Object)Event.CHANNEL_WRITABILITY_CHANGED), queue.poll());
        Assert.assertEquals((Object)((Object)Event.USER_EVENT_TRIGGERED), queue.poll());
        Assert.assertEquals((Object)((Object)Event.CHANNEL_READ), queue.poll());
        Assert.assertEquals((Object)((Object)Event.CHANNEL_READ_COMPLETE), queue.poll());
        handler.removeInboundHandler();
        Assert.assertEquals((Object)((Object)Event.HANDLER_REMOVED), queue.poll());
        channel.pipeline().fireChannelWritabilityChanged();
        channel.pipeline().fireUserEventTriggered(MSG);
        channel.pipeline().fireChannelRead(MSG);
        channel.pipeline().fireChannelReadComplete();
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testOutboundEvents() {
        final ArrayDeque queue = new ArrayDeque();
        ChannelInboundHandlerAdapter inboundHandler = new ChannelInboundHandlerAdapter();
        ChannelOutboundHandlerAdapter outboundHandler = new ChannelOutboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.HANDLER_ADDED);
            }

            public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.HANDLER_REMOVED);
            }

            public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
                queue.add(Event.BIND);
            }

            public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
                queue.add(Event.CONNECT);
            }

            public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                queue.add(Event.DISCONNECT);
            }

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                queue.add(Event.CLOSE);
            }

            public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                queue.add(Event.DEREGISTER);
            }

            public void read(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.READ);
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                queue.add(Event.WRITE);
            }

            public void flush(ChannelHandlerContext ctx) throws Exception {
                queue.add(Event.FLUSH);
            }
        };
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)inboundHandler, (ChannelOutboundHandler)outboundHandler);
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addFirst(new ChannelHandler[]{handler});
        CombinedChannelDuplexHandlerTest.doOutboundOperations((Channel)channel);
        Assert.assertEquals((Object)((Object)Event.HANDLER_ADDED), queue.poll());
        Assert.assertEquals((Object)((Object)Event.BIND), queue.poll());
        Assert.assertEquals((Object)((Object)Event.CONNECT), queue.poll());
        Assert.assertEquals((Object)((Object)Event.WRITE), queue.poll());
        Assert.assertEquals((Object)((Object)Event.FLUSH), queue.poll());
        Assert.assertEquals((Object)((Object)Event.READ), queue.poll());
        Assert.assertEquals((Object)((Object)Event.CLOSE), queue.poll());
        Assert.assertEquals((Object)((Object)Event.CLOSE), queue.poll());
        Assert.assertEquals((Object)((Object)Event.DEREGISTER), queue.poll());
        handler.removeOutboundHandler();
        Assert.assertEquals((Object)((Object)Event.HANDLER_REMOVED), queue.poll());
        CombinedChannelDuplexHandlerTest.doOutboundOperations((Channel)channel);
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    private static void doOutboundOperations(Channel channel) {
        channel.pipeline().bind(ADDRESS);
        channel.pipeline().connect(ADDRESS);
        channel.pipeline().write(MSG);
        channel.pipeline().flush();
        channel.pipeline().read();
        channel.pipeline().disconnect();
        channel.pipeline().close();
        channel.pipeline().deregister();
    }

    @Test(timeout=3000L)
    public void testPromisesPassed() {
        ChannelOutboundHandlerAdapter outboundHandler = new ChannelOutboundHandlerAdapter(){

            public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
                promise.setSuccess();
            }

            public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
                promise.setSuccess();
            }

            public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                promise.setSuccess();
            }

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                promise.setSuccess();
            }

            public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                promise.setSuccess();
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                promise.setSuccess();
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{outboundHandler, new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter())});
        ChannelPipeline pipeline = ch.pipeline();
        ChannelPromise promise = ch.newPromise();
        pipeline.connect((SocketAddress)new InetSocketAddress(0), null, promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.bind((SocketAddress)new InetSocketAddress(0), promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.close(promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.disconnect(promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.write((Object)"test", promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.deregister(promise);
        promise.syncUninterruptibly();
        ch.finish();
    }

    @Test(expected=IllegalStateException.class)
    public void testNotSharable() {
        new CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler>(){

            public boolean isSharable() {
                return true;
            }
        };
    }

    private static enum Event {
        REGISTERED,
        UNREGISTERED,
        ACTIVE,
        INACTIVE,
        CHANNEL_READ,
        CHANNEL_READ_COMPLETE,
        EXCEPTION_CAUGHT,
        USER_EVENT_TRIGGERED,
        CHANNEL_WRITABILITY_CHANGED,
        HANDLER_ADDED,
        HANDLER_REMOVED,
        BIND,
        CONNECT,
        WRITE,
        FLUSH,
        READ,
        REGISTER,
        DEREGISTER,
        CLOSE,
        DISCONNECT;

    }
}

