/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageList;
import io.netty.channel.oio.AbstractOioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private volatile boolean inputShutdown;
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);

    protected AbstractOioByteChannel(Channel parent, Integer id) {
        super(parent, id);
    }

    protected boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected boolean checkInputShutdown() {
        if (this.inputShutdown) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead() {
        if (this.checkInputShutdown()) {
            return;
        }
        ChannelPipeline pipeline = this.pipeline();
        ByteBuf byteBuf = this.alloc().buffer();
        boolean closed = false;
        boolean read = false;
        boolean firedInboundBufferSuspeneded = false;
        try {
            do {
                int maxCapacity;
                int localReadAmount;
                if ((localReadAmount = this.doReadBytes(byteBuf)) > 0) {
                    read = true;
                } else if (localReadAmount < 0) {
                    closed = true;
                }
                int available = this.available();
                if (available <= 0) {
                    break;
                }
                if (byteBuf.isWritable()) continue;
                int capacity = byteBuf.capacity();
                if (capacity == (maxCapacity = byteBuf.maxCapacity())) {
                    if (!read) continue;
                    read = false;
                    pipeline.fireMessageReceived(byteBuf);
                    byteBuf = this.alloc().buffer();
                    continue;
                }
                int writerIndex = byteBuf.writerIndex();
                if (writerIndex + available > maxCapacity) {
                    byteBuf.capacity(maxCapacity);
                    continue;
                }
                byteBuf.ensureWritable(available);
            } while (this.config().isAutoRead());
        }
        catch (Throwable t) {
            if (read) {
                read = false;
                pipeline.fireMessageReceived(byteBuf);
            }
            if (t instanceof IOException) {
                closed = true;
                pipeline.fireExceptionCaught(t);
            } else {
                firedInboundBufferSuspeneded = true;
                pipeline.fireChannelReadSuspended();
                pipeline.fireExceptionCaught(t);
                this.unsafe().close(this.voidPromise());
            }
        }
        finally {
            if (read) {
                pipeline.fireMessageReceived(byteBuf);
            } else {
                byteBuf.release();
            }
            if (closed) {
                this.inputShutdown = true;
                if (this.isOpen()) {
                    if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                        pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                    } else {
                        this.unsafe().close(this.unsafe().voidPromise());
                    }
                }
            } else if (!firedInboundBufferSuspeneded) {
                pipeline.fireChannelReadSuspended();
            }
        }
    }

    @Override
    protected int doWrite(MessageList<Object> msgs, int index) throws Exception {
        int size = msgs.size();
        int writeIndex = index;
        while (writeIndex < size) {
            Object msg = msgs.get(writeIndex);
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                while (buf.isReadable()) {
                    this.doWriteBytes(buf);
                }
                buf.release();
                ++writeIndex;
                continue;
            }
            if (msg instanceof FileRegion) {
                FileRegion region = (FileRegion)msg;
                this.doWriteFileRegion(region);
                region.release();
                ++writeIndex;
                continue;
            }
            throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg));
        }
        return writeIndex - index;
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteFileRegion(FileRegion var1) throws Exception;
}

