/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.MessageListProcessor;
import io.netty.util.Recycler;
import io.netty.util.Signal;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class MessageList<T>
implements Iterable<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int MIN_INITIAL_CAPACITY = 4;
    private static final Recycler<MessageList<?>> RECYCLER = new Recycler<MessageList<?>>(){

        protected MessageList<?> newObject(Recycler.Handle handle) {
            return new MessageList(handle);
        }
    };
    private final Recycler.Handle handle;
    private T[] elements;
    private int size;
    private int modifications;
    private boolean byteBufsOnly = true;

    public static <T> MessageList<T> newInstance() {
        return MessageList.newInstance(8);
    }

    public static <T> MessageList<T> newInstance(int minCapacity) {
        MessageList ret = (MessageList)RECYCLER.get();
        ret.ensureCapacity(minCapacity);
        ret.modifications = 0;
        return ret;
    }

    public static <T> MessageList<T> newInstance(T value) {
        MessageList<int> ret = MessageList.newInstance(4);
        ret.add((int)value);
        return ret;
    }

    public MessageList<T> retainAll() {
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            ByteBufUtil.retain(this.elements[i]);
        }
        return this;
    }

    public MessageList<T> retainAll(int increment) {
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            ByteBufUtil.retain(this.elements[i], (int)increment);
        }
        return this;
    }

    public boolean releaseAll() {
        boolean releasedAll = true;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            releasedAll &= ByteBufUtil.release(this.elements[i]);
        }
        return releasedAll;
    }

    public boolean releaseAll(int decrement) {
        boolean releasedAll = true;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            releasedAll &= ByteBufUtil.release(this.elements[i], (int)decrement);
        }
        return releasedAll;
    }

    public boolean releaseAllAndRecycle() {
        return this.releaseAll() && this.recycle();
    }

    public boolean releaseAllAndRecycle(int decrement) {
        return this.releaseAll(decrement) && this.recycle();
    }

    public boolean recycle() {
        this.clear();
        return RECYCLER.recycle((Object)this, this.handle);
    }

    MessageList(Recycler.Handle handle) {
        this(handle, 8);
    }

    MessageList(Recycler.Handle handle, int initialCapacity) {
        this.handle = handle;
        initialCapacity = MessageList.normalizeCapacity(initialCapacity);
        this.elements = this.newArray(initialCapacity);
    }

    private MessageList(Recycler.Handle handle, T[] elements, int size) {
        this.handle = handle;
        this.elements = elements;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T get(int index) {
        this.checkExclusive(index);
        return this.elements[index];
    }

    public MessageList<T> set(int index, T value) {
        this.checkExclusive(index);
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.elements[index] = value;
        return this;
    }

    public MessageList<T> add(T value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        ++this.modifications;
        int oldSize = this.size;
        int newSize = oldSize + 1;
        this.ensureCapacity(newSize);
        this.elements[oldSize] = value;
        this.size = newSize;
        if (this.byteBufsOnly && !(value instanceof ByteBuf)) {
            this.byteBufsOnly = false;
        }
        return this;
    }

    public MessageList<T> add(T[] src) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        return this.add(src, 0, src.length);
    }

    public MessageList<T> add(T[] src, int srcIdx, int srcLen) {
        this.checkElements(src, srcIdx, srcLen);
        ++this.modifications;
        int oldSize = this.size;
        int newSize = oldSize + srcLen;
        this.ensureCapacity(newSize);
        System.arraycopy(src, srcIdx, this.elements, oldSize, srcLen);
        this.size = newSize;
        if (this.byteBufsOnly) {
            for (int i = srcIdx; i < srcIdx; ++i) {
                if (src[i] instanceof ByteBuf) continue;
                this.byteBufsOnly = false;
                break;
            }
        }
        return this;
    }

    public MessageList<T> add(MessageList<T> src) {
        return this.add(src, 0, src.size());
    }

    public MessageList<T> add(MessageList<T> src, int srcIdx, int srcLen) {
        return this.add(src.elements, srcIdx, srcLen);
    }

    public MessageList<T> clear() {
        ++this.modifications;
        Arrays.fill(this.elements, 0, this.size, null);
        this.byteBufsOnly = true;
        this.size = 0;
        return this;
    }

    public MessageList<T> copy() {
        return new MessageList<Object>(this.handle, (Object[])this.elements.clone(), this.size);
    }

    public MessageList<T> copy(int index, int length) {
        this.checkRange(index, length);
        MessageList<T> copy = new MessageList<T>(this.handle, length);
        System.arraycopy(this.elements, index, copy.elements, 0, length);
        copy.size = length;
        return copy;
    }

    public <U> MessageList<U> cast() {
        return this;
    }

    public boolean forEach(MessageListProcessor<? super T> proc) {
        if (proc == null) {
            throw new NullPointerException("proc");
        }
        MessageListProcessor<T> p = proc;
        int size = this.size;
        try {
            for (int i = 0; i < size; ++i) {
                i += p.process(this, i, this.elements[i]);
            }
        }
        catch (Signal abort) {
            abort.expect(MessageListProcessor.ABORT);
            return false;
        }
        catch (Exception e) {
            PlatformDependent.throwException((Throwable)e);
        }
        return true;
    }

    public boolean forEach(int index, int length, MessageListProcessor<? super T> proc) {
        this.checkRange(index, length);
        if (proc == null) {
            throw new NullPointerException("proc");
        }
        MessageListProcessor<T> p = proc;
        int end = index + length;
        try {
            for (int i = index; i < end; i += p.process(this, i, this.elements[i])) {
            }
        }
        catch (Signal abort) {
            abort.expect(MessageListProcessor.ABORT);
            return false;
        }
        catch (Exception e) {
            PlatformDependent.throwException((Throwable)e);
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new MessageListIterator();
    }

    public boolean containsOnly(Class<?> clazz) {
        if (clazz == ByteBuf.class) {
            return this.byteBufsOnly;
        }
        for (int i = 0; i < this.size; ++i) {
            if (clazz.isInstance(this.elements[i])) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int capacity) {
        if (this.elements.length >= capacity) {
            return;
        }
        T[] newElements = this.newArray(MessageList.normalizeCapacity(capacity));
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        this.elements = newElements;
    }

    private static int normalizeCapacity(int initialCapacity) {
        if (initialCapacity <= 4) {
            initialCapacity = 4;
        } else {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        return initialCapacity;
    }

    private T[] newArray(int initialCapacity) {
        return new Object[initialCapacity];
    }

    private void checkExclusive(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
    }

    private void checkRange(int index, int length) {
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("index: " + index + ", length: " + length + ", size: " + this.size);
        }
    }

    private void checkElements(T[] src, int srcIdx, int srcLen) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        int end = srcIdx + srcLen;
        for (int i = srcIdx; i < end; ++i) {
            if (src[i] != null) continue;
            throw new NullPointerException("src[" + i + ']');
        }
    }

    private final class MessageListIterator
    implements Iterator<T> {
        private int index;
        private int expectedModifications;

        private MessageListIterator() {
            this.expectedModifications = MessageList.this.modifications;
        }

        private void checkConcurrentModifications() {
            if (this.expectedModifications != MessageList.this.modifications) {
                throw new ConcurrentModificationException();
            }
            if (this.index > MessageList.this.size) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < MessageList.this.size;
        }

        @Override
        public T next() {
            this.checkConcurrentModifications();
            if (this.hasNext()) {
                return MessageList.this.elements[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }
}

