/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ThreadPerChannelEventLoop;
import io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadPerChannelEventLoopGroup
implements EventLoopGroup {
    private static final Object[] NO_ARGS = new Object[0];
    private static final StackTraceElement[] STACK_ELEMENTS = new StackTraceElement[0];
    private final Object[] childArgs;
    private final int maxChannels;
    final ThreadFactory threadFactory;
    final Set<ThreadPerChannelEventLoop> activeChildren = Collections.newSetFromMap(PlatformDependent.newConcurrentHashMap());
    final Queue<ThreadPerChannelEventLoop> idleChildren = new ConcurrentLinkedQueue<ThreadPerChannelEventLoop>();
    private final ChannelException tooManyChannels;

    protected ThreadPerChannelEventLoopGroup() {
        this(0);
    }

    protected ThreadPerChannelEventLoopGroup(int maxChannels) {
        this(maxChannels, Executors.defaultThreadFactory(), new Object[0]);
    }

    protected ThreadPerChannelEventLoopGroup(int maxChannels, ThreadFactory threadFactory, Object ... args) {
        if (maxChannels < 0) {
            throw new IllegalArgumentException(String.format("maxChannels: %d (expected: >= 0)", maxChannels));
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        this.childArgs = args == null ? NO_ARGS : (Object[])args.clone();
        this.maxChannels = maxChannels;
        this.threadFactory = threadFactory;
        this.tooManyChannels = new ChannelException("too many channels (max: " + maxChannels + ')');
        this.tooManyChannels.setStackTrace(STACK_ELEMENTS);
    }

    protected ThreadPerChannelEventLoop newChild(Object ... args) throws Exception {
        return new ThreadPerChannelEventLoop(this);
    }

    @Override
    public EventLoop next() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        for (EventLoop eventLoop : this.activeChildren) {
            eventLoop.shutdown();
        }
        for (EventLoop eventLoop : this.idleChildren) {
            eventLoop.shutdown();
        }
    }

    public boolean isShutdown() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isShutdown()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isShutdown()) continue;
            return false;
        }
        return true;
    }

    public boolean isTerminated() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isTerminated()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeLeft;
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        for (EventLoop eventLoop : this.activeChildren) {
            do {
                if ((timeLeft = deadline - System.nanoTime()) > 0L) continue;
                return this.isTerminated();
            } while (!eventLoop.awaitTermination(timeLeft, TimeUnit.NANOSECONDS));
        }
        for (EventLoop eventLoop : this.idleChildren) {
            do {
                if ((timeLeft = deadline - System.nanoTime()) > 0L) continue;
                return this.isTerminated();
            } while (!eventLoop.awaitTermination(timeLeft, TimeUnit.NANOSECONDS));
        }
        return this.isTerminated();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        try {
            return this.nextChild().register(channel);
        }
        catch (Throwable t) {
            return channel.newFailedFuture(t);
        }
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        try {
            return this.nextChild().register(channel, promise);
        }
        catch (Throwable t) {
            promise.setFailure(t);
            return promise;
        }
    }

    private EventLoop nextChild() throws Exception {
        ThreadPerChannelEventLoop loop = this.idleChildren.poll();
        if (loop == null) {
            if (this.maxChannels > 0 && this.activeChildren.size() >= this.maxChannels) {
                throw this.tooManyChannels;
            }
            loop = this.newChild(this.childArgs);
        }
        this.activeChildren.add(loop);
        return loop;
    }
}

