/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.group;

import io.netty.buffer.BufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.FileRegion;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.CombinedIterator;
import io.netty.channel.group.DefaultChannelGroupFuture;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import io.netty.util.internal.PlatformDependent;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private static final ImmediateEventExecutor DEFAULT_EXECUTOR = new ImmediateEventExecutor();
    private final String name;
    private final EventExecutor executor;
    private final ConcurrentMap<Integer, Channel> serverChannels = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<Integer, Channel> nonServerChannels = PlatformDependent.newConcurrentHashMap();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            DefaultChannelGroup.this.remove(future.channel());
        }
    };

    public DefaultChannelGroup() {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()));
    }

    public DefaultChannelGroup(EventExecutor executor) {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()), executor);
    }

    public DefaultChannelGroup(String name) {
        this(name, DEFAULT_EXECUTOR);
    }

    public DefaultChannelGroup(String name, EventExecutor executor) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.executor = executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    @Override
    public Channel find(Integer id) {
        Channel c = (Channel)this.nonServerChannels.get(id);
        if (c != null) {
            return c;
        }
        return (Channel)this.serverChannels.get(id);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.nonServerChannels.containsKey(o) || this.serverChannels.containsKey(o);
        }
        if (o instanceof Channel) {
            Channel c = (Channel)o;
            if (o instanceof ServerChannel) {
                return this.serverChannels.containsKey(c.id());
            }
            return this.nonServerChannels.containsKey(c.id());
        }
        return false;
    }

    @Override
    public boolean add(Channel channel) {
        boolean added;
        ConcurrentMap<Integer, Channel> map = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean bl = added = map.putIfAbsent(channel.id(), channel) == null;
        if (added) {
            channel.closeFuture().addListener(this.remover);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        Channel c = null;
        if (o instanceof Integer) {
            c = (Channel)this.nonServerChannels.remove(o);
            if (c == null) {
                c = (Channel)this.serverChannels.remove(o);
            }
        } else if (o instanceof Channel) {
            c = (Channel)o;
            c = c instanceof ServerChannel ? (Channel)this.serverChannels.remove(c.id()) : (Channel)this.nonServerChannels.remove(c.id());
        }
        if (c == null) {
            return false;
        }
        c.closeFuture().removeListener(this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.values().iterator(), this.nonServerChannels.values().iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return channels.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return channels.toArray(a);
    }

    @Override
    public ChannelGroupFuture close() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.id(), c.close().awaitUninterruptibly());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.id(), c.close());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures, this.executor);
    }

    @Override
    public ChannelGroupFuture disconnect() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.id(), c.disconnect());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.id(), c.disconnect());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures, this.executor);
    }

    @Override
    public ChannelGroupFuture write(Object message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.nonServerChannels.values()) {
            BufUtil.retain((Object)message);
            futures.put(c.id(), c.write(message));
        }
        BufUtil.release((Object)message);
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures, this.executor);
    }

    @Override
    public ChannelGroupFuture sendFile(FileRegion region) {
        if (region == null) {
            throw new NullPointerException("region");
        }
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.nonServerChannels.values()) {
            BufUtil.retain((Object)region);
            futures.put(c.id(), c.sendFile(region));
        }
        BufUtil.release((Object)region);
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures, this.executor);
    }

    @Override
    public ChannelGroupFuture flush() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.id(), c.flush());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures, this.executor);
    }

    @Override
    public ChannelGroupFuture deregister() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.id(), c.deregister());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.id(), c.deregister());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures, this.executor);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int compareTo(ChannelGroup o) {
        int v = this.name().compareTo(o.name());
        if (v != 0) {
            return v;
        }
        return System.identityHashCode(this) - System.identityHashCode(o);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(name: " + this.name() + ", size: " + this.size() + ')';
    }

    private static final class ImmediateEventExecutor
    implements EventExecutor {
        private final Future successedFuture = new SucceededFuture((EventExecutor)this);

        private ImmediateEventExecutor() {
        }

        public EventExecutor next() {
            return this;
        }

        public EventExecutorGroup parent() {
            return null;
        }

        public boolean inEventLoop() {
            return true;
        }

        public boolean inEventLoop(Thread thread) {
            return true;
        }

        public void shutdown() {
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        public Promise newPromise() {
            return new DefaultPromise((EventExecutor)this);
        }

        public Future newSucceededFuture() {
            return this.successedFuture;
        }

        public Future newFailedFuture(Throwable cause) {
            return new FailedFuture((EventExecutor)this, cause);
        }

        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        public <T> java.util.concurrent.Future<T> submit(Callable<T> task) {
            if (task == null) {
                throw new NullPointerException("task");
            }
            FutureTask<T> future = new FutureTask<T>(task);
            future.run();
            return future;
        }

        public <T> java.util.concurrent.Future<T> submit(Runnable task, T result) {
            if (task == null) {
                throw new NullPointerException("task");
            }
            FutureTask<T> future = new FutureTask<T>(task, result);
            future.run();
            return future;
        }

        public java.util.concurrent.Future<?> submit(Runnable task) {
            if (task == null) {
                throw new NullPointerException("task");
            }
            FutureTask<Object> future = new FutureTask<Object>(task, null);
            future.run();
            return future;
        }

        public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            if (tasks == null) {
                throw new NullPointerException("tasks");
            }
            ArrayList<java.util.concurrent.Future<T>> futures = new ArrayList<java.util.concurrent.Future<T>>();
            for (Callable<T> task : tasks) {
                futures.add(this.submit(task));
            }
            return futures;
        }

        public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            if (tasks == null) {
                throw new NullPointerException("tasks");
            }
            ArrayList<java.util.concurrent.Future<T>> futures = new ArrayList<java.util.concurrent.Future<T>>();
            for (Callable<T> task : tasks) {
                futures.add(this.submit(task));
            }
            return futures;
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            if (tasks == null) {
                throw new NullPointerException("tasks");
            }
            if (tasks.isEmpty()) {
                throw new IllegalArgumentException("tasks must be non empty");
            }
            return this.invokeAll(tasks).get(0).get();
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            if (tasks == null) {
                throw new NullPointerException("tasks");
            }
            if (tasks.isEmpty()) {
                throw new IllegalArgumentException("tasks must be non empty");
            }
            return this.invokeAll(tasks).get(0).get();
        }

        public void execute(Runnable command) {
            if (command == null) {
                throw new NullPointerException("command");
            }
            command.run();
        }
    }
}

