/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.BlockingOperationException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFlushPromiseNotifier;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.Signal;
import io.netty.util.internal.InternalLogger;
import io.netty.util.internal.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class DefaultChannelPromise
extends ChannelFlushPromiseNotifier.FlushCheckpoint
implements ChannelPromise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPromise.class);
    private static final int MAX_LISTENER_STACK_DEPTH = 8;
    private static final ThreadLocal<Integer> LISTENER_STACK_DEPTH = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final Signal SUCCESS = new Signal(DefaultChannelPromise.class.getName() + ".SUCCESS");
    private final Channel channel;
    private volatile Throwable cause;
    private Object listeners;
    private int waiters;
    private long flushCheckpoint;

    public DefaultChannelPromise(Channel channel) {
        this.channel = channel;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public boolean isDone() {
        return this.cause != null;
    }

    @Override
    public boolean isSuccess() {
        return this.cause == SUCCESS;
    }

    @Override
    public Throwable cause() {
        Throwable cause = this.cause;
        return cause == SUCCESS ? null : cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPromise addListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            DefaultChannelPromise.notifyListener(this, listener);
            return this;
        }
        boolean notifyNow = false;
        DefaultChannelPromise defaultChannelPromise = this;
        synchronized (defaultChannelPromise) {
            if (this.isDone()) {
                notifyNow = true;
            } else if (this.listeners == null) {
                this.listeners = listener;
            } else if (this.listeners instanceof DefaultChannelPromiseListeners) {
                ((DefaultChannelPromiseListeners)this.listeners).add(listener);
            } else {
                this.listeners = new DefaultChannelPromiseListeners((ChannelFutureListener)this.listeners, listener);
            }
        }
        if (notifyNow) {
            DefaultChannelPromise.notifyListener(this, listener);
        }
        return this;
    }

    @Override
    public ChannelPromise addListeners(ChannelFutureListener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (ChannelFutureListener l : listeners) {
            if (l == null) break;
            this.addListener(l);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPromise removeListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            return this;
        }
        DefaultChannelPromise defaultChannelPromise = this;
        synchronized (defaultChannelPromise) {
            if (!this.isDone()) {
                if (this.listeners instanceof DefaultChannelPromiseListeners) {
                    ((DefaultChannelPromiseListeners)this.listeners).remove(listener);
                } else if (this.listeners == listener) {
                    this.listeners = null;
                }
            }
        }
        return this;
    }

    @Override
    public ChannelPromise removeListeners(ChannelFutureListener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (ChannelFutureListener l : listeners) {
            if (l == null) break;
            this.removeListener(l);
        }
        return this;
    }

    @Override
    public ChannelPromise sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new ChannelException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPromise await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultChannelPromise defaultChannelPromise = this;
        synchronized (defaultChannelPromise) {
            while (!this.isDone()) {
                this.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                }
                finally {
                    --this.waiters;
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPromise awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        boolean interrupted = false;
        DefaultChannelPromise defaultChannelPromise = this;
        synchronized (defaultChannelPromise) {
            while (!this.isDone()) {
                this.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    --this.waiters;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkDeadLock() {
        if (this.channel().isRegistered() && this.channel().eventLoop().inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    @Override
    public ChannelPromise setSuccess() {
        if (this.success0()) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean trySuccess() {
        if (this.success0()) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean success0() {
        if (this.isDone()) {
            return false;
        }
        DefaultChannelPromise defaultChannelPromise = this;
        synchronized (defaultChannelPromise) {
            if (this.isDone()) {
                return false;
            }
            this.cause = SUCCESS;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        return true;
    }

    @Override
    public ChannelPromise setFailure(Throwable cause) {
        if (this.failure0(cause)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.failure0(cause)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean failure0(Throwable cause) {
        if (this.isDone()) {
            return false;
        }
        DefaultChannelPromise defaultChannelPromise = this;
        synchronized (defaultChannelPromise) {
            if (this.isDone()) {
                return false;
            }
            this.cause = cause;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        return true;
    }

    private void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        if (this.channel().eventLoop().inEventLoop()) {
            if (this.listeners instanceof DefaultChannelPromiseListeners) {
                for (ChannelFutureListener l : (DefaultChannelPromiseListeners)this.listeners) {
                    DefaultChannelPromise.notifyListener0(this, l);
                }
            } else {
                DefaultChannelPromise.notifyListener0(this, (ChannelFutureListener)this.listeners);
            }
            this.listeners = null;
        } else {
            final Object listeners = this.listeners;
            this.listeners = null;
            this.channel().eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    if (listeners instanceof DefaultChannelPromiseListeners) {
                        for (ChannelFutureListener l : (DefaultChannelPromiseListeners)listeners) {
                            DefaultChannelPromise.notifyListener0(DefaultChannelPromise.this, l);
                        }
                    } else {
                        DefaultChannelPromise.notifyListener0(DefaultChannelPromise.this, (ChannelFutureListener)listeners);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyListener(final ChannelFuture f, final ChannelFutureListener l) {
        Integer stackDepth;
        EventLoop loop = f.channel().eventLoop();
        if (loop.inEventLoop() && (stackDepth = LISTENER_STACK_DEPTH.get()) < 8) {
            LISTENER_STACK_DEPTH.set(stackDepth + 1);
            try {
                DefaultChannelPromise.notifyListener0(f, l);
            }
            finally {
                LISTENER_STACK_DEPTH.set(stackDepth);
            }
            return;
        }
        loop.execute(new Runnable(){

            @Override
            public void run() {
                DefaultChannelPromise.notifyListener(f, l);
            }
        });
    }

    private static void notifyListener0(ChannelFuture f, ChannelFutureListener l) {
        block2: {
            try {
                l.operationComplete(f);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + ChannelFutureListener.class.getSimpleName() + '.', t);
            }
        }
    }

    @Override
    long flushCheckpoint() {
        return this.flushCheckpoint;
    }

    @Override
    void flushCheckpoint(long checkpoint) {
        this.flushCheckpoint = checkpoint;
    }

    @Override
    ChannelPromise future() {
        return this;
    }

    private static final class DefaultChannelPromiseListeners
    extends ArrayList<ChannelFutureListener> {
        private static final long serialVersionUID = 7414281537694651180L;

        DefaultChannelPromiseListeners(ChannelFutureListener firstListener, ChannelFutureListener secondListener) {
            super(2);
            this.add(firstListener);
            this.add(secondListener);
        }
    }
}

