/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ChannelBuf;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerType;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOperationHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelStateHandler;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventExecutorGroup;
import io.netty.channel.NoSuchBufferException;
import io.netty.util.DefaultAttributeMap;
import java.net.SocketAddress;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class DefaultChannelHandlerContext
extends DefaultAttributeMap
implements ChannelHandlerContext {
    private static final EnumSet<ChannelHandlerType> EMPTY_TYPE = EnumSet.noneOf(ChannelHandlerType.class);
    static final int DIR_INBOUND = 1;
    static final int DIR_OUTBOUND = Integer.MIN_VALUE;
    volatile DefaultChannelHandlerContext next;
    volatile DefaultChannelHandlerContext prev;
    private final Channel channel;
    private final DefaultChannelPipeline pipeline;
    EventExecutor executor;
    private final String name;
    private final Set<ChannelHandlerType> type;
    final int directions;
    private final ChannelHandler handler;
    final MessageBuf<Object> inMsgBuf;
    final ByteBuf inByteBuf;
    final MessageBuf<Object> outMsgBuf;
    final ByteBuf outByteBuf;
    final AtomicReference<MessageBridge> inMsgBridge;
    final AtomicReference<MessageBridge> outMsgBridge;
    final AtomicReference<ByteBridge> inByteBridge;
    final AtomicReference<ByteBridge> outByteBridge;
    final AtomicBoolean readable = new AtomicBoolean(true);
    final Runnable fireChannelRegisteredTask = new Runnable(){

        @Override
        public void run() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this;
            try {
                ((ChannelStateHandler)ctx.handler).channelRegistered(ctx);
            }
            catch (Throwable t) {
                DefaultChannelHandlerContext.this.pipeline.notifyHandlerException(t);
            }
        }
    };
    final Runnable fireChannelUnregisteredTask = new Runnable(){

        @Override
        public void run() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this;
            try {
                ((ChannelStateHandler)ctx.handler).channelUnregistered(ctx);
            }
            catch (Throwable t) {
                DefaultChannelHandlerContext.this.pipeline.notifyHandlerException(t);
            }
        }
    };
    final Runnable fireChannelActiveTask = new Runnable(){

        @Override
        public void run() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this;
            try {
                ((ChannelStateHandler)ctx.handler).channelActive(ctx);
            }
            catch (Throwable t) {
                DefaultChannelHandlerContext.this.pipeline.notifyHandlerException(t);
            }
        }
    };
    final Runnable fireChannelInactiveTask = new Runnable(){

        @Override
        public void run() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this;
            try {
                ((ChannelStateHandler)ctx.handler).channelInactive(ctx);
            }
            catch (Throwable t) {
                DefaultChannelHandlerContext.this.pipeline.notifyHandlerException(t);
            }
        }
    };
    final Runnable curCtxFireInboundBufferUpdatedTask = new Runnable(){

        @Override
        public void run() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this;
            DefaultChannelHandlerContext.this.flushBridge();
            try {
                ((ChannelStateHandler)ctx.handler).inboundBufferUpdated(ctx);
            }
            catch (Throwable t) {
                DefaultChannelHandlerContext.this.pipeline.notifyHandlerException(t);
            }
            finally {
                ByteBuf buf = DefaultChannelHandlerContext.this.inByteBuf;
                if (buf != null && !buf.readable()) {
                    buf.discardReadBytes();
                }
            }
        }
    };
    private final Runnable nextCtxFireInboundBufferUpdatedTask = new Runnable(){

        @Override
        public void run() {
            DefaultChannelHandlerContext next = DefaultChannelPipeline.nextContext(DefaultChannelHandlerContext.this.next, 1);
            if (next != null) {
                next.fillBridge();
                EventExecutor executor = next.executor();
                if (executor.inEventLoop()) {
                    next.curCtxFireInboundBufferUpdatedTask.run();
                } else {
                    executor.execute(next.curCtxFireInboundBufferUpdatedTask);
                }
            }
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutorGroup group, DefaultChannelHandlerContext prev, DefaultChannelHandlerContext next, String name, ChannelHandler handler) {
        ChannelBuf buf;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        int typeValue = 0;
        Object type = EMPTY_TYPE.clone();
        if (handler instanceof ChannelStateHandler) {
            ((AbstractCollection)type).add(ChannelHandlerType.STATE);
            typeValue |= 1;
            if (handler instanceof ChannelInboundHandler) {
                ((AbstractCollection)type).add(ChannelHandlerType.INBOUND);
            }
        }
        if (handler instanceof ChannelOperationHandler) {
            ((AbstractCollection)type).add(ChannelHandlerType.OPERATION);
            typeValue |= Integer.MIN_VALUE;
            if (handler instanceof ChannelOutboundHandler) {
                ((AbstractCollection)type).add(ChannelHandlerType.OUTBOUND);
            }
        }
        this.type = Collections.unmodifiableSet(type);
        this.directions = typeValue;
        this.prev = prev;
        this.next = next;
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        if (group != null) {
            EventExecutor childExecutor = pipeline.childExecutors.get(group);
            if (childExecutor == null) {
                childExecutor = group.next();
                pipeline.childExecutors.put(group, childExecutor);
            }
            this.executor = childExecutor;
        } else {
            this.executor = this.channel.isRegistered() ? this.channel.eventLoop() : null;
        }
        if (((AbstractCollection)type).contains((Object)ChannelHandlerType.INBOUND)) {
            try {
                buf = ((ChannelInboundHandler)handler).newInboundBuffer(this);
            }
            catch (Exception e) {
                throw new ChannelPipelineException("A user handler failed to create a new inbound buffer.", e);
            }
            if (buf == null) {
                throw new ChannelPipelineException("A user handler's newInboundBuffer() returned null");
            }
            if (buf instanceof ByteBuf) {
                this.inByteBuf = (ByteBuf)buf;
                this.inByteBridge = new AtomicReference();
                this.inMsgBuf = null;
                this.inMsgBridge = null;
            } else {
                if (!(buf instanceof MessageBuf)) throw new Error();
                this.inByteBuf = null;
                this.inByteBridge = null;
                this.inMsgBuf = (MessageBuf)buf;
                this.inMsgBridge = new AtomicReference();
            }
        } else {
            this.inByteBuf = null;
            this.inByteBridge = null;
            this.inMsgBuf = null;
            this.inMsgBridge = null;
        }
        if (((AbstractCollection)type).contains((Object)ChannelHandlerType.OUTBOUND)) {
            try {
                buf = ((ChannelOutboundHandler)handler).newOutboundBuffer(this);
            }
            catch (Exception e) {
                throw new ChannelPipelineException("A user handler failed to create a new outbound buffer.", e);
            }
            if (buf == null) {
                throw new ChannelPipelineException("A user handler's newOutboundBuffer() returned null");
            }
            if (buf instanceof ByteBuf) {
                this.outByteBuf = (ByteBuf)buf;
                this.outByteBridge = new AtomicReference();
                this.outMsgBuf = null;
                this.outMsgBridge = null;
                return;
            } else {
                if (!(buf instanceof MessageBuf)) throw new Error();
                this.outByteBuf = null;
                this.outByteBridge = null;
                this.outMsgBuf = (MessageBuf)buf;
                this.outMsgBridge = new AtomicReference();
            }
            return;
        }
        this.outByteBuf = null;
        this.outByteBridge = null;
        this.outMsgBuf = null;
        this.outMsgBridge = null;
    }

    void fillBridge() {
        Object bridge;
        if (this.inMsgBridge != null) {
            bridge = this.inMsgBridge.get();
            if (bridge != null) {
                ((MessageBridge)bridge).fill();
            }
        } else if (this.inByteBridge != null && (bridge = this.inByteBridge.get()) != null) {
            ((ByteBridge)bridge).fill();
        }
        if (this.outMsgBridge != null) {
            bridge = this.outMsgBridge.get();
            if (bridge != null) {
                ((MessageBridge)bridge).fill();
            }
        } else if (this.outByteBridge != null && (bridge = this.outByteBridge.get()) != null) {
            ((ByteBridge)bridge).fill();
        }
    }

    void flushBridge() {
        Object bridge;
        if (this.inMsgBridge != null) {
            bridge = this.inMsgBridge.get();
            if (bridge != null) {
                ((MessageBridge)bridge).flush(this.inMsgBuf);
            }
        } else if (this.inByteBridge != null && (bridge = this.inByteBridge.get()) != null) {
            ((ByteBridge)bridge).flush(this.inByteBuf);
        }
        if (this.outMsgBridge != null) {
            bridge = this.outMsgBridge.get();
            if (bridge != null) {
                ((MessageBridge)bridge).flush(this.outMsgBuf);
            }
        } else if (this.outByteBridge != null && (bridge = this.outByteBridge.get()) != null) {
            ((ByteBridge)bridge).flush(this.outByteBuf);
        }
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            this.executor = this.channel.eventLoop();
            return this.executor;
        }
        return this.executor;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Set<ChannelHandlerType> types() {
        return this.type;
    }

    @Override
    public boolean hasInboundByteBuffer() {
        return this.inByteBuf != null;
    }

    @Override
    public boolean hasInboundMessageBuffer() {
        return this.inMsgBuf != null;
    }

    @Override
    public ByteBuf inboundByteBuffer() {
        if (this.inByteBuf == null) {
            if (this.handler instanceof ChannelInboundHandler) {
                throw new NoSuchBufferException(String.format("the handler '%s' has no inbound byte buffer; it implements %s, but its newInboundBuffer() method created a %s.", this.name, ChannelInboundHandler.class.getSimpleName(), MessageBuf.class.getSimpleName()));
            }
            throw new NoSuchBufferException(String.format("the handler '%s' has no inbound byte buffer; it does not implement %s.", this.name, ChannelInboundHandler.class.getSimpleName()));
        }
        return this.inByteBuf;
    }

    @Override
    public <T> MessageBuf<T> inboundMessageBuffer() {
        if (this.inMsgBuf == null) {
            if (this.handler instanceof ChannelInboundHandler) {
                throw new NoSuchBufferException(String.format("the handler '%s' has no inbound message buffer; it implements %s, but its newInboundBuffer() method created a %s.", this.name, ChannelInboundHandler.class.getSimpleName(), ByteBuf.class.getSimpleName()));
            }
            throw new NoSuchBufferException(String.format("the handler '%s' has no inbound message buffer; it does not implement %s.", this.name, ChannelInboundHandler.class.getSimpleName()));
        }
        return this.inMsgBuf;
    }

    @Override
    public boolean hasOutboundByteBuffer() {
        return this.outByteBuf != null;
    }

    @Override
    public boolean hasOutboundMessageBuffer() {
        return this.outMsgBuf != null;
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        if (this.outByteBuf == null) {
            if (this.handler instanceof ChannelOutboundHandler) {
                throw new NoSuchBufferException(String.format("the handler '%s' has no outbound byte buffer; it implements %s, but its newOutboundBuffer() method created a %s.", this.name, ChannelOutboundHandler.class.getSimpleName(), MessageBuf.class.getSimpleName()));
            }
            throw new NoSuchBufferException(String.format("the handler '%s' has no outbound byte buffer; it does not implement %s.", this.name, ChannelOutboundHandler.class.getSimpleName()));
        }
        return this.outByteBuf;
    }

    @Override
    public <T> MessageBuf<T> outboundMessageBuffer() {
        if (this.outMsgBuf == null) {
            if (this.handler instanceof ChannelOutboundHandler) {
                throw new NoSuchBufferException(String.format("the handler '%s' has no outbound message buffer; it implements %s, but its newOutboundBuffer() method created a %s.", this.name, ChannelOutboundHandler.class.getSimpleName(), ByteBuf.class.getSimpleName()));
            }
            throw new NoSuchBufferException(String.format("the handler '%s' has no outbound message buffer; it does not implement %s.", this.name, ChannelOutboundHandler.class.getSimpleName()));
        }
        return this.outMsgBuf;
    }

    @Override
    public boolean hasNextInboundByteBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        while (ctx != null) {
            if (ctx.inByteBridge != null) {
                return true;
            }
            ctx = ctx.next;
        }
        return false;
    }

    @Override
    public boolean hasNextInboundMessageBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        while (ctx != null) {
            if (ctx.inMsgBridge != null) {
                return true;
            }
            ctx = ctx.next;
        }
        return false;
    }

    @Override
    public boolean hasNextOutboundByteBuffer() {
        return this.pipeline.hasNextOutboundByteBuffer(this.prev);
    }

    @Override
    public boolean hasNextOutboundMessageBuffer() {
        return this.pipeline.hasNextOutboundMessageBuffer(this.prev);
    }

    @Override
    public ByteBuf nextInboundByteBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        Thread currentThread = Thread.currentThread();
        while (true) {
            if (ctx == null) {
                if (this.prev != null) {
                    throw new NoSuchBufferException(String.format("the handler '%s' could not find a %s whose inbound buffer is %s.", this.name, ChannelInboundHandler.class.getSimpleName(), ByteBuf.class.getSimpleName()));
                }
                throw new NoSuchBufferException(String.format("the pipeline does not contain a %s whose inbound buffer is %s.", ChannelInboundHandler.class.getSimpleName(), ByteBuf.class.getSimpleName()));
            }
            if (ctx.inByteBuf != null) {
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.inByteBuf;
                }
                ByteBridge bridge = ctx.inByteBridge.get();
                if (bridge == null && !ctx.inByteBridge.compareAndSet(null, bridge = new ByteBridge())) {
                    bridge = ctx.inByteBridge.get();
                }
                return bridge.byteBuf;
            }
            ctx = ctx.next;
        }
    }

    @Override
    public MessageBuf<Object> nextInboundMessageBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        Thread currentThread = Thread.currentThread();
        while (true) {
            if (ctx == null) {
                if (this.prev != null) {
                    throw new NoSuchBufferException(String.format("the handler '%s' could not find a %s whose inbound buffer is %s.", this.name, ChannelInboundHandler.class.getSimpleName(), MessageBuf.class.getSimpleName()));
                }
                throw new NoSuchBufferException(String.format("the pipeline does not contain a %s whose inbound buffer is %s.", ChannelInboundHandler.class.getSimpleName(), MessageBuf.class.getSimpleName()));
            }
            if (ctx.inMsgBuf != null) {
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.inMsgBuf;
                }
                MessageBridge bridge = ctx.inMsgBridge.get();
                if (bridge == null && !ctx.inMsgBridge.compareAndSet(null, bridge = new MessageBridge())) {
                    bridge = ctx.inMsgBridge.get();
                }
                return bridge.msgBuf;
            }
            ctx = ctx.next;
        }
    }

    @Override
    public ByteBuf nextOutboundByteBuffer() {
        return this.pipeline.nextOutboundByteBuffer(this.prev);
    }

    @Override
    public MessageBuf<Object> nextOutboundMessageBuffer() {
        return this.pipeline.nextOutboundMessageBuffer(this.prev);
    }

    @Override
    public void fireChannelRegistered() {
        DefaultChannelHandlerContext next = DefaultChannelPipeline.nextContext(this.next, 1);
        if (next != null) {
            EventExecutor executor = next.executor();
            if (executor.inEventLoop()) {
                next.fireChannelRegisteredTask.run();
            } else {
                executor.execute(next.fireChannelRegisteredTask);
            }
        }
    }

    @Override
    public void fireChannelUnregistered() {
        DefaultChannelHandlerContext next = DefaultChannelPipeline.nextContext(this.next, 1);
        if (next != null) {
            EventExecutor executor = next.executor();
            if (executor.inEventLoop()) {
                next.fireChannelUnregisteredTask.run();
            } else {
                executor.execute(next.fireChannelUnregisteredTask);
            }
        }
    }

    @Override
    public void fireChannelActive() {
        DefaultChannelHandlerContext next = DefaultChannelPipeline.nextContext(this.next, 1);
        if (next != null) {
            EventExecutor executor = next.executor();
            if (executor.inEventLoop()) {
                next.fireChannelActiveTask.run();
            } else {
                executor.execute(next.fireChannelActiveTask);
            }
        }
    }

    @Override
    public void fireChannelInactive() {
        DefaultChannelHandlerContext next = DefaultChannelPipeline.nextContext(this.next, 1);
        if (next != null) {
            EventExecutor executor = next.executor();
            if (executor.inEventLoop()) {
                next.fireChannelInactiveTask.run();
            } else {
                executor.execute(next.fireChannelInactiveTask);
            }
        }
    }

    @Override
    public void fireExceptionCaught(final Throwable cause) {
        block9: {
            if (cause == null) {
                throw new NullPointerException("cause");
            }
            DefaultChannelHandlerContext next = this.next;
            if (next != null) {
                EventExecutor executor = next.executor();
                if (executor.inEventLoop()) {
                    try {
                        next.handler().exceptionCaught(next, cause);
                    }
                    catch (Throwable t) {
                        if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                            DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler's exceptionCaught() method while handling the following exception:", cause);
                        }
                        break block9;
                    }
                }
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            DefaultChannelHandlerContext.this.fireExceptionCaught(cause);
                        }
                    });
                }
                catch (Throwable t) {
                    if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                        DefaultChannelPipeline.logger.warn("Failed to submit an exceptionCaught() event.", t);
                        DefaultChannelPipeline.logger.warn("The exceptionCaught() event that was failed to submit was:", cause);
                    }
                    break block9;
                }
            }
            DefaultChannelPipeline.logger.warn("An exceptionCaught() event was fired, and it reached at the end of the pipeline.  It usually means the last inbound handler in the pipeline did not handle the exception.", cause);
        }
    }

    @Override
    public void fireUserEventTriggered(final Object event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        DefaultChannelHandlerContext next = this.next;
        if (next != null) {
            EventExecutor executor = next.executor();
            if (executor.inEventLoop()) {
                try {
                    next.handler().userEventTriggered(next, event);
                }
                catch (Throwable t) {
                    this.pipeline.notifyHandlerException(t);
                }
            } else {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.fireUserEventTriggered(event);
                    }
                });
            }
        }
    }

    @Override
    public void fireInboundBufferUpdated() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.nextCtxFireInboundBufferUpdatedTask.run();
        } else {
            executor.execute(this.nextCtxFireInboundBufferUpdatedTask);
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newFuture());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newFuture());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newFuture());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newFuture());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newFuture());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newFuture());
    }

    @Override
    public ChannelFuture flush() {
        return this.flush(this.newFuture());
    }

    @Override
    public ChannelFuture write(Object message) {
        return this.write(message, this.newFuture());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelFuture future) {
        return this.pipeline.bind(DefaultChannelPipeline.nextContext(this.prev, Integer.MIN_VALUE), localAddress, future);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelFuture future) {
        return this.connect(remoteAddress, null, future);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelFuture future) {
        return this.pipeline.connect(DefaultChannelPipeline.nextContext(this.prev, Integer.MIN_VALUE), remoteAddress, localAddress, future);
    }

    @Override
    public ChannelFuture disconnect(ChannelFuture future) {
        return this.pipeline.disconnect(DefaultChannelPipeline.nextContext(this.prev, Integer.MIN_VALUE), future);
    }

    @Override
    public ChannelFuture close(ChannelFuture future) {
        return this.pipeline.close(DefaultChannelPipeline.nextContext(this.prev, Integer.MIN_VALUE), future);
    }

    @Override
    public ChannelFuture deregister(ChannelFuture future) {
        return this.pipeline.deregister(DefaultChannelPipeline.nextContext(this.prev, Integer.MIN_VALUE), future);
    }

    @Override
    public ChannelFuture flush(final ChannelFuture future) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            DefaultChannelHandlerContext prev = DefaultChannelPipeline.nextContext(this.prev, Integer.MIN_VALUE);
            prev.fillBridge();
            this.pipeline.flush(prev, future);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.flush(future);
                }
            });
        }
        return future;
    }

    @Override
    public ChannelFuture write(Object message, ChannelFuture future) {
        return this.pipeline.write(this.prev, message, future);
    }

    @Override
    public ChannelFuture newFuture() {
        return this.channel.newFuture();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.channel.newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.channel.newFailedFuture(cause);
    }

    @Override
    public boolean isReadable() {
        return this.readable.get();
    }

    @Override
    public void readable(boolean readable) {
        this.pipeline.readable(this, readable);
    }

    static final class ByteBridge {
        final ByteBuf byteBuf = Unpooled.buffer();
        final Queue<ByteBuf> exchangeBuf = new ConcurrentLinkedQueue<ByteBuf>();

        ByteBridge() {
        }

        void fill() {
            if (!this.byteBuf.readable()) {
                return;
            }
            ByteBuf data = this.byteBuf.readBytes(this.byteBuf.readableBytes());
            this.byteBuf.discardReadBytes();
            this.exchangeBuf.add(data);
        }

        void flush(ByteBuf out) {
            ByteBuf data;
            while ((data = this.exchangeBuf.poll()) != null) {
                out.writeBytes(data);
            }
        }
    }

    static final class MessageBridge {
        final MessageBuf<Object> msgBuf = Unpooled.messageBuffer();
        final Queue<Object[]> exchangeBuf = new ConcurrentLinkedQueue<Object[]>();

        MessageBridge() {
        }

        void fill() {
            if (this.msgBuf.isEmpty()) {
                return;
            }
            Object[] data = this.msgBuf.toArray();
            this.msgBuf.clear();
            this.exchangeBuf.add(data);
        }

        void flush(MessageBuf<Object> out) {
            Object[] data;
            while ((data = this.exchangeBuf.poll()) != null) {
                Collections.addAll(out, data);
            }
        }
    }
}

