/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;

public class Bootstrap
extends AbstractBootstrap<Bootstrap> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private SocketAddress remoteAddress;

    public Bootstrap remoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public Bootstrap remoteAddress(String host, int port) {
        this.remoteAddress = new InetSocketAddress(host, port);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress host, int port) {
        this.remoteAddress = new InetSocketAddress(host, port);
        return this;
    }

    @Override
    public ChannelFuture bind(ChannelFuture future) {
        this.validate(future);
        if (this.localAddress() == null) {
            throw new IllegalStateException("localAddress not set");
        }
        try {
            this.init(future.channel());
        }
        catch (Throwable t) {
            future.setFailure(t);
            return future;
        }
        if (!Bootstrap.ensureOpen(future)) {
            return future;
        }
        return future.channel().bind(this.localAddress(), future).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    public ChannelFuture connect() {
        this.validate();
        Channel channel = this.factory().newChannel();
        return this.connect(channel.newFuture());
    }

    public ChannelFuture connect(ChannelFuture future) {
        this.validate(future);
        if (this.remoteAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        try {
            this.init(future.channel());
        }
        catch (Throwable t) {
            future.setFailure(t);
            return future;
        }
        if (!Bootstrap.ensureOpen(future)) {
            return future;
        }
        if (this.localAddress() == null) {
            future.channel().connect(this.remoteAddress, future);
        } else {
            future.channel().connect(this.remoteAddress, this.localAddress(), future);
        }
        return future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    private void init(Channel channel) throws Exception {
        if (channel.isActive()) {
            throw new IllegalStateException("channel already active:: " + channel);
        }
        if (channel.isRegistered()) {
            throw new IllegalStateException("channel already registered: " + channel);
        }
        if (!channel.isOpen()) {
            throw new ClosedChannelException();
        }
        ChannelPipeline p = channel.pipeline();
        p.addLast(this.handler());
        for (Map.Entry<ChannelOption<?>, Object> e : this.options().entrySet()) {
            try {
                if (channel.config().setOption(e.getKey(), e.getValue())) continue;
                logger.warn("Unknown channel option: " + e);
            }
            catch (Throwable t) {
                logger.warn("Failed to set a channel option: " + channel, t);
            }
        }
        this.group().register(channel).syncUninterruptibly();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
    }

    public Bootstrap newBootstrap(SocketAddress localAddress, SocketAddress remoteAddress, ChannelHandler handler) {
        this.validate();
        Bootstrap cb = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().handler(handler)).channelFactory(this.factory())).group(this.group())).localAddress(localAddress)).remoteAddress(remoteAddress);
        cb.options().putAll(this.options());
        return cb;
    }

    public Bootstrap newBootstrap(SocketAddress localAddress, SocketAddress remoteAddress) {
        return this.newBootstrap(localAddress, remoteAddress, this.handler());
    }
}

