/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Bootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private EventLoopGroup group;
    private Channel channel;
    private ChannelHandler handler;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;

    public Bootstrap group(EventLoopGroup group) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (this.group != null) {
            throw new IllegalStateException("group set already");
        }
        this.group = group;
        return this;
    }

    public Bootstrap channel(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (this.channel != null) {
            throw new IllegalStateException("channel set already");
        }
        this.channel = channel;
        return this;
    }

    public <T> Bootstrap option(ChannelOption<T> option, T value) {
        if (option == null) {
            throw new NullPointerException("option");
        }
        if (value == null) {
            this.options.remove(option);
        } else {
            this.options.put(option, value);
        }
        return this;
    }

    public Bootstrap handler(ChannelHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
        return this;
    }

    public Bootstrap localAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public Bootstrap localAddress(int port) {
        this.localAddress = new InetSocketAddress(port);
        return this;
    }

    public Bootstrap localAddress(String host, int port) {
        this.localAddress = new InetSocketAddress(host, port);
        return this;
    }

    public Bootstrap localAddress(InetAddress host, int port) {
        this.localAddress = new InetSocketAddress(host, port);
        return this;
    }

    public Bootstrap remoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public Bootstrap remoteAddress(String host, int port) {
        this.remoteAddress = new InetSocketAddress(host, port);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress host, int port) {
        this.remoteAddress = new InetSocketAddress(host, port);
        return this;
    }

    public ChannelFuture bind() {
        this.validate();
        return this.bind(this.channel.newFuture());
    }

    public ChannelFuture bind(ChannelFuture future) {
        this.validate(future);
        if (this.localAddress == null) {
            throw new IllegalStateException("localAddress not set");
        }
        try {
            this.init();
        }
        catch (Throwable t) {
            future.setFailure(t);
            return future;
        }
        if (!Bootstrap.ensureOpen(future)) {
            return future;
        }
        return this.channel.bind(this.localAddress, future).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    public ChannelFuture connect() {
        this.validate();
        return this.connect(this.channel.newFuture());
    }

    public ChannelFuture connect(ChannelFuture future) {
        this.validate(future);
        if (this.remoteAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        try {
            this.init();
        }
        catch (Throwable t) {
            future.setFailure(t);
            return future;
        }
        if (!Bootstrap.ensureOpen(future)) {
            return future;
        }
        if (this.localAddress == null) {
            this.channel.connect(this.remoteAddress, future);
        } else {
            this.channel.connect(this.remoteAddress, this.localAddress, future);
        }
        return future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    private void init() throws Exception {
        if (this.channel.isActive()) {
            throw new IllegalStateException("channel already active:: " + this.channel);
        }
        if (this.channel.isRegistered()) {
            throw new IllegalStateException("channel already registered: " + this.channel);
        }
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        ChannelPipeline p = this.channel.pipeline();
        p.addLast(this.handler);
        for (Map.Entry<ChannelOption<?>, Object> e : this.options.entrySet()) {
            try {
                if (this.channel.config().setOption(e.getKey(), e.getValue())) continue;
                logger.warn("Unknown channel option: " + e);
            }
            catch (Throwable t) {
                logger.warn("Failed to set a channel option: " + this.channel, t);
            }
        }
        this.group.register(this.channel).syncUninterruptibly();
    }

    private static boolean ensureOpen(ChannelFuture future) {
        if (!future.channel().isOpen()) {
            future.setFailure(new ChannelException("initialization failure"));
            return false;
        }
        return true;
    }

    public void shutdown() {
        if (this.group != null) {
            this.group.shutdown();
        }
    }

    private void validate() {
        if (this.group == null) {
            throw new IllegalStateException("group not set");
        }
        if (this.channel == null) {
            throw new IllegalStateException("channel not set");
        }
        if (this.handler == null) {
            throw new IllegalStateException("handler not set");
        }
    }

    private void validate(ChannelFuture future) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (future.channel() != this.channel) {
            throw new IllegalArgumentException("future.channel() must be the same channel.");
        }
        this.validate();
    }
}

