/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ChannelBufType;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.aio.AbstractAioChannel;
import io.netty.channel.socket.aio.AioCompletionHandler;
import io.netty.channel.socket.aio.AioEventLoop;
import io.netty.channel.socket.aio.AioServerSocketChannel;
import io.netty.channel.socket.aio.AioSocketChannelConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;

public class AioSocketChannel
extends AbstractAioChannel
implements SocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(ChannelBufType.BYTE, false);
    private static final CompletionHandler<Void, AioSocketChannel> CONNECT_HANDLER = new ConnectHandler();
    private static final CompletionHandler<Integer, AioSocketChannel> WRITE_HANDLER = new WriteHandler();
    private static final CompletionHandler<Integer, AioSocketChannel> READ_HANDLER = new ReadHandler();
    private final AioSocketChannelConfig config;
    private boolean flushing;

    private static AsynchronousSocketChannel newSocket(AsynchronousChannelGroup group) {
        try {
            return AsynchronousSocketChannel.open(group);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public AioSocketChannel(AioEventLoop eventLoop) {
        this(null, null, eventLoop, AioSocketChannel.newSocket(eventLoop.group));
    }

    AioSocketChannel(AioServerSocketChannel parent, Integer id, AioEventLoop eventLoop, AsynchronousSocketChannel ch) {
        super(parent, id, eventLoop, ch);
        this.config = new AioSocketChannelConfig(ch);
    }

    @Override
    public boolean isActive() {
        return this.javaChannel().isOpen() && this.remoteAddress0() != null;
    }

    @Override
    protected AsynchronousSocketChannel javaChannel() {
        return (AsynchronousSocketChannel)super.javaChannel();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelFuture future) {
        if (localAddress != null) {
            try {
                this.javaChannel().bind(localAddress);
            }
            catch (IOException e) {
                future.setFailure(e);
                return;
            }
        }
        this.javaChannel().connect(remoteAddress, this, CONNECT_HANDLER);
    }

    @Override
    protected InetSocketAddress localAddress0() {
        try {
            return (InetSocketAddress)this.javaChannel().getLocalAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        try {
            return (InetSocketAddress)this.javaChannel().getRemoteAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Runnable doRegister() throws Exception {
        super.doRegister();
        if (this.remoteAddress() == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                AioSocketChannel.this.beginRead();
            }
        };
    }

    private static boolean expandReadBuffer(ByteBuf byteBuf) {
        if (!byteBuf.writable()) {
            byteBuf.ensureWritableBytes(4096);
            return true;
        }
        return false;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.javaChannel().bind(localAddress);
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.javaChannel().close();
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        buf.discardReadBytes();
        if (buf.readable()) {
            this.javaChannel().write(buf.nioBuffer(), this, WRITE_HANDLER);
        } else {
            this.notifyFlushFutures();
            this.flushing = false;
        }
    }

    private void beginRead() {
        ByteBuf byteBuf = this.pipeline().inboundByteBuffer();
        if (!byteBuf.readable()) {
            byteBuf.discardReadBytes();
        } else {
            AioSocketChannel.expandReadBuffer(byteBuf);
        }
        ByteBuffer buffer = byteBuf.nioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
        this.javaChannel().read(buffer, this, READ_HANDLER);
    }

    @Override
    public AioSocketChannelConfig config() {
        return this.config;
    }

    private static final class ConnectHandler
    extends AioCompletionHandler<Void, AioSocketChannel> {
        private ConnectHandler() {
        }

        @Override
        protected void completed0(Void result, AioSocketChannel channel) {
            channel.beginRead();
            ((AbstractAioChannel.AsyncUnsafe)channel.unsafe()).connectSuccess();
            channel.pipeline().fireChannelActive();
        }

        @Override
        protected void failed0(Throwable exc, AioSocketChannel channel) {
            ((AbstractAioChannel.AsyncUnsafe)channel.unsafe()).connectFailed(exc);
        }
    }

    private static final class ReadHandler
    extends AioCompletionHandler<Integer, AioSocketChannel> {
        private ReadHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void completed0(Integer result, AioSocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            ByteBuf byteBuf = pipeline.inboundByteBuffer();
            boolean closed = false;
            boolean read = false;
            try {
                int localReadAmount = result;
                if (localReadAmount > 0) {
                    byteBuf.writerIndex(byteBuf.writerIndex() + localReadAmount);
                    AioSocketChannel.expandReadBuffer(byteBuf);
                    read = true;
                } else if (localReadAmount < 0) {
                    closed = true;
                }
            }
            catch (Throwable t) {
                if (read) {
                    read = false;
                    pipeline.fireInboundBufferUpdated();
                }
                if (!(t instanceof ClosedChannelException)) {
                    pipeline.fireExceptionCaught(t);
                    if (t instanceof IOException) {
                        channel.unsafe().close(channel.unsafe().voidFuture());
                    }
                }
            }
            finally {
                if (read) {
                    pipeline.fireInboundBufferUpdated();
                }
                if (closed && channel.isOpen()) {
                    channel.unsafe().close(channel.unsafe().voidFuture());
                } else {
                    channel.beginRead();
                }
            }
        }

        @Override
        protected void failed0(Throwable t, AioSocketChannel channel) {
            if (t instanceof ClosedChannelException) {
                return;
            }
            channel.pipeline().fireExceptionCaught(t);
            if (t instanceof IOException) {
                channel.unsafe().close(channel.unsafe().voidFuture());
            } else {
                channel.beginRead();
            }
        }
    }

    private static final class WriteHandler
    extends AioCompletionHandler<Integer, AioSocketChannel> {
        private WriteHandler() {
        }

        @Override
        protected void completed0(Integer result, AioSocketChannel channel) {
            boolean empty;
            ByteBuf buf = channel.unsafe().directOutboundContext().outboundByteBuffer();
            int writtenBytes = result;
            if (writtenBytes > 0) {
                buf.readerIndex(buf.readerIndex() + writtenBytes);
            }
            boolean bl = empty = !buf.readable();
            if (empty) {
                buf.discardReadBytes();
            }
            channel.notifyFlushFutures(writtenBytes);
            channel.flushing = false;
            if (!channel.isActive()) {
                return;
            }
            if (buf.readable()) {
                try {
                    channel.doFlushByteBuffer(buf);
                }
                catch (Exception e) {
                    this.failed0((Throwable)e, channel);
                }
            }
        }

        @Override
        protected void failed0(Throwable cause, AioSocketChannel channel) {
            channel.notifyFlushFutures(cause);
            channel.pipeline().fireExceptionCaught(cause);
            ByteBuf buf = channel.unsafe().directOutboundContext().outboundByteBuffer();
            if (!buf.readable()) {
                buf.discardReadBytes();
            }
            channel.flushing = false;
        }
    }
}

