/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.channel.EventExecutor;
import io.netty.channel.EventLoopException;
import io.netty.channel.MultithreadEventLoop;
import io.netty.channel.socket.aio.AbstractAioChannel;
import io.netty.channel.socket.aio.AioChildEventLoop;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;

public class AioEventLoop
extends MultithreadEventLoop {
    private static final ConcurrentMap<Class<?>, Field[]> fieldCache = new ConcurrentHashMap();
    private static final Field[] FAILURE = new Field[0];
    final AsynchronousChannelGroup group;

    public AioEventLoop() {
        this(0);
    }

    public AioEventLoop(int nThreads) {
        this(nThreads, null);
    }

    public AioEventLoop(int nThreads, ThreadFactory threadFactory) {
        super(nThreads, threadFactory, new Object[0]);
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(this);
        }
        catch (IOException e) {
            throw new EventLoopException("Failed to create an AsynchronousChannelGroup", e);
        }
    }

    @Override
    public void execute(Runnable command) {
        Class<?> commandType = command.getClass();
        if (commandType.getName().startsWith("sun.nio.ch.")) {
            this.executeAioTask(command);
        } else {
            super.execute(command);
        }
    }

    private void executeAioTask(Runnable command) {
        AbstractAioChannel ch = null;
        try {
            ch = AioEventLoop.findChannel(command);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventExecutor l = ch != null ? ch.eventLoop() : this.unsafe().nextChild();
        if (l.isShutdown()) {
            command.run();
        } else {
            l.execute(command);
        }
    }

    private static AbstractAioChannel findChannel(Runnable command) throws Exception {
        Class<?> commandType = command.getClass();
        Field[] fields = (Field[])fieldCache.get(commandType);
        if (fields == null) {
            try {
                fields = AioEventLoop.findFieldSequence(command, new ArrayDeque<Field>(2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fields == null) {
                fields = FAILURE;
            }
            fieldCache.put(commandType, fields);
        }
        if (fields == FAILURE) {
            return null;
        }
        int lastIndex = fields.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            command = (Runnable)fields[i].get(command);
        }
        return (AbstractAioChannel)fields[lastIndex].get(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field[] findFieldSequence(Runnable command, Deque<Field> fields) throws Exception {
        Class<?> commandType = command.getClass();
        for (Field f : commandType.getDeclaredFields()) {
            if (f.getType() == Runnable.class) {
                f.setAccessible(true);
                fields.addLast(f);
                try {
                    Field[] ret = AioEventLoop.findFieldSequence((Runnable)f.get(command), fields);
                    if (ret != null) {
                        Field[] fieldArray = ret;
                        return fieldArray;
                    }
                }
                finally {
                    fields.removeLast();
                }
            }
            if (f.getType() != Object.class) continue;
            f.setAccessible(true);
            fields.addLast(f);
            try {
                Object candidate = f.get(command);
                if (!(candidate instanceof AbstractAioChannel)) continue;
                Field[] fieldArray = fields.toArray(new Field[fields.size()]);
                return fieldArray;
            }
            finally {
                fields.removeLast();
            }
        }
        return null;
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, Object ... args) throws Exception {
        return new AioChildEventLoop(this, threadFactory);
    }
}

