/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ChannelBuf;
import io.netty.buffer.ChannelBufType;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerLifeCycleException;
import io.netty.channel.ChannelOperationHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelStateHandlerAdapter;
import io.netty.channel.DefaultChannelHandlerContext;
import io.netty.channel.DefaultChannelPipelineModificationTask;
import io.netty.channel.EventExecutor;
import io.netty.channel.NoSuchBufferException;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;

public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    final Channel channel;
    private final Channel.Unsafe unsafe;
    final DefaultChannelHandlerContext head;
    private volatile DefaultChannelHandlerContext tail;
    private final Map<String, DefaultChannelHandlerContext> name2ctx = new HashMap<String, DefaultChannelHandlerContext>(4);
    private boolean firedChannelActive;
    private boolean fireInboundBufferUpdatedOnActivation;
    final Map<EventExecutor, EventExecutor> childExecutors = new IdentityHashMap<EventExecutor, EventExecutor>();

    public DefaultChannelPipeline(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
        HeadHandler headHandler = new HeadHandler();
        this.tail = this.head = new DefaultChannelHandlerContext(this, null, null, null, DefaultChannelPipeline.generateName(headHandler), headHandler);
        this.unsafe = channel.unsafe();
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline addFirst(String name, ChannelHandler handler) {
        return this.addFirst(null, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addFirst(EventExecutor executor, final String name, ChannelHandler handler) {
        try {
            Future<Throwable> future;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                this.checkDuplicateName(name);
                final DefaultChannelHandlerContext nextCtx = this.head.next;
                final DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, executor, this.head, nextCtx, name, handler);
                if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                    this.addFirst0(name, nextCtx, newCtx);
                    return this;
                }
                future = newCtx.executor().submit(new DefaultChannelPipelineModificationTask(this){

                    @Override
                    void doCall() {
                        DefaultChannelPipeline.this.checkDuplicateName(name);
                        DefaultChannelPipeline.this.addFirst0(name, nextCtx, newCtx);
                    }
                });
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return this;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void addFirst0(String name, DefaultChannelHandlerContext nextCtx, DefaultChannelHandlerContext newCtx) {
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        if (nextCtx != null) {
            nextCtx.prev = newCtx;
        }
        this.head.next = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addLast(String name, ChannelHandler handler) {
        return this.addLast(null, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addLast(EventExecutor executor, final String name, ChannelHandler handler) {
        try {
            Future<Throwable> future;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                this.checkDuplicateName(name);
                final DefaultChannelHandlerContext oldTail = this.tail;
                final DefaultChannelHandlerContext newTail = new DefaultChannelHandlerContext(this, executor, oldTail, null, name, handler);
                if (!newTail.channel().isRegistered() || newTail.executor().inEventLoop()) {
                    this.addLast0(name, oldTail, newTail);
                    return this;
                }
                future = newTail.executor().submit(new DefaultChannelPipelineModificationTask(this){

                    @Override
                    void doCall() {
                        DefaultChannelPipeline.this.checkDuplicateName(name);
                        DefaultChannelPipeline.this.addLast0(name, oldTail, newTail);
                    }
                });
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return this;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void addLast0(String name, DefaultChannelHandlerContext oldTail, DefaultChannelHandlerContext newTail) {
        DefaultChannelPipeline.callBeforeAdd(newTail);
        oldTail.next = newTail;
        this.tail = newTail;
        this.name2ctx.put(name, newTail);
        this.callAfterAdd(newTail);
    }

    @Override
    public ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        return this.addBefore(null, baseName, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addBefore(EventExecutor executor, String baseName, final String name, ChannelHandler handler) {
        try {
            Future<Throwable> future;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                final DefaultChannelHandlerContext ctx = this.getContextOrDie(baseName);
                this.checkDuplicateName(name);
                final DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, executor, ctx.prev, ctx, name, handler);
                if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                    this.addBefore0(name, ctx, newCtx);
                    return this;
                }
                future = newCtx.executor().submit(new DefaultChannelPipelineModificationTask(this){

                    @Override
                    void doCall() {
                        DefaultChannelPipeline.this.checkDuplicateName(name);
                        DefaultChannelPipeline.this.addBefore0(name, ctx, newCtx);
                    }
                });
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return this;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void addBefore0(String name, DefaultChannelHandlerContext ctx, DefaultChannelHandlerContext newCtx) {
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        ctx.prev.next = newCtx;
        ctx.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        return this.addAfter(null, baseName, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addAfter(EventExecutor executor, String baseName, final String name, ChannelHandler handler) {
        try {
            Future<Throwable> future;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                final DefaultChannelHandlerContext ctx = this.getContextOrDie(baseName);
                if (ctx == this.tail) {
                    return this.addLast(name, handler);
                }
                this.checkDuplicateName(name);
                final DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, executor, ctx, ctx.next, name, handler);
                if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                    this.addAfter0(name, ctx, newCtx);
                    return this;
                }
                future = newCtx.executor().submit(new DefaultChannelPipelineModificationTask(this){

                    @Override
                    void doCall() {
                        DefaultChannelPipeline.this.checkDuplicateName(name);
                        DefaultChannelPipeline.this.addAfter0(name, ctx, newCtx);
                    }
                });
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return this;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void addAfter0(String name, DefaultChannelHandlerContext ctx, DefaultChannelHandlerContext newCtx) {
        this.checkDuplicateName(name);
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        ctx.next.prev = newCtx;
        ctx.next = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addFirst(ChannelHandler ... handlers) {
        return this.addFirst((EventExecutor)null, handlers);
    }

    @Override
    public ChannelPipeline addFirst(EventExecutor executor, ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0 || handlers[0] == null) {
            return this;
        }
        for (int size = 1; size < handlers.length && handlers[size] != null; ++size) {
        }
        for (int i = size - 1; i >= 0; --i) {
            ChannelHandler h = handlers[i];
            this.addFirst(executor, DefaultChannelPipeline.generateName(h), h);
        }
        return this;
    }

    @Override
    public ChannelPipeline addLast(ChannelHandler ... handlers) {
        return this.addLast((EventExecutor)null, handlers);
    }

    @Override
    public ChannelPipeline addLast(EventExecutor executor, ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        for (ChannelHandler h : handlers) {
            if (h == null) break;
            this.addLast(executor, DefaultChannelPipeline.generateName(h), h);
        }
        return this;
    }

    private static String generateName(ChannelHandler handler) {
        String type = handler.getClass().getSimpleName();
        StringBuilder buf = new StringBuilder(type.length() + 10);
        buf.append(type);
        buf.append("-0");
        buf.append(Long.toHexString((long)System.identityHashCode(handler) & 0xFFFFFFFFL | 0x100000000L));
        buf.setCharAt(buf.length() - 9, 'x');
        return buf.toString();
    }

    @Override
    public void remove(ChannelHandler handler) {
        this.remove(this.getContextOrDie(handler));
    }

    @Override
    public ChannelHandler remove(String name) {
        return this.remove(this.getContextOrDie(name)).handler();
    }

    @Override
    public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType)).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultChannelHandlerContext remove(final DefaultChannelHandlerContext ctx) {
        try {
            DefaultChannelHandlerContext context;
            Future<Throwable> future;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                if (this.head == this.tail) {
                    return null;
                }
                if (ctx == this.head) {
                    throw new Error();
                }
                if (ctx == this.tail) {
                    if (this.head == this.tail) {
                        throw new NoSuchElementException();
                    }
                    final DefaultChannelHandlerContext oldTail = this.tail;
                    if (!oldTail.channel().isRegistered() || oldTail.executor().inEventLoop()) {
                        this.removeLast0(oldTail);
                        return oldTail;
                    }
                    future = oldTail.executor().submit(new DefaultChannelPipelineModificationTask(this){

                        @Override
                        void doCall() {
                            DefaultChannelPipeline.this.removeLast0(oldTail);
                        }
                    });
                    context = oldTail;
                } else {
                    if (!ctx.channel().isRegistered() || ctx.executor().inEventLoop()) {
                        this.remove0(ctx);
                        return ctx;
                    }
                    future = ctx.executor().submit(new DefaultChannelPipelineModificationTask(this){

                        @Override
                        void doCall() {
                            DefaultChannelPipeline.this.remove0(ctx);
                        }
                    });
                    context = ctx;
                }
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return context;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void remove0(DefaultChannelHandlerContext ctx) {
        DefaultChannelHandlerContext next;
        DefaultChannelPipeline.callBeforeRemove(ctx);
        DefaultChannelHandlerContext prev = ctx.prev;
        prev.next = next = ctx.next;
        next.prev = prev;
        this.name2ctx.remove(ctx.name());
        DefaultChannelPipeline.callAfterRemove(ctx);
    }

    @Override
    public ChannelHandler removeFirst() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.head.next).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandler removeLast() {
        try {
            Future<Throwable> future;
            DefaultChannelHandlerContext oldTail;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                if (this.head == this.tail) {
                    throw new NoSuchElementException();
                }
                oldTail = this.tail;
                if (!oldTail.channel().isRegistered() || oldTail.executor().inEventLoop()) {
                    this.removeLast0(oldTail);
                    return oldTail.handler();
                }
                future = oldTail.executor().submit(new DefaultChannelPipelineModificationTask(this){

                    @Override
                    void doCall() {
                        DefaultChannelPipeline.this.removeLast0(oldTail);
                    }
                });
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return oldTail.handler();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void removeLast0(DefaultChannelHandlerContext oldTail) {
        DefaultChannelPipeline.callBeforeRemove(oldTail);
        oldTail.prev.next = null;
        this.tail = oldTail.prev;
        this.name2ctx.remove(oldTail.name());
        DefaultChannelPipeline.callBeforeRemove(oldTail);
    }

    @Override
    public void replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler);
    }

    @Override
    public ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler);
    }

    @Override
    public <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelHandler replace(final DefaultChannelHandlerContext ctx, final String newName, ChannelHandler newHandler) {
        try {
            Future<Throwable> future;
            DefaultChannelPipeline defaultChannelPipeline = this;
            synchronized (defaultChannelPipeline) {
                if (ctx == this.head) {
                    throw new IllegalArgumentException();
                }
                if (ctx == this.tail) {
                    if (this.head == this.tail) {
                        throw new NoSuchElementException();
                    }
                    final DefaultChannelHandlerContext oldTail = this.tail;
                    final DefaultChannelHandlerContext newTail = new DefaultChannelHandlerContext(this, null, oldTail, null, newName, newHandler);
                    if (!oldTail.channel().isRegistered() || oldTail.executor().inEventLoop()) {
                        this.removeLast0(oldTail);
                        this.checkDuplicateName(newName);
                        this.addLast0(newName, this.tail, newTail);
                        return ctx.handler();
                    }
                    future = oldTail.executor().submit(new DefaultChannelPipelineModificationTask(this){

                        @Override
                        void doCall() {
                            DefaultChannelPipeline.this.removeLast0(oldTail);
                            DefaultChannelPipeline.this.checkDuplicateName(newName);
                            DefaultChannelPipeline.this.addLast0(newName, DefaultChannelPipeline.this.tail, newTail);
                        }
                    });
                } else {
                    DefaultChannelHandlerContext next;
                    DefaultChannelHandlerContext prev;
                    DefaultChannelHandlerContext newCtx;
                    boolean sameName = ctx.name().equals(newName);
                    if (!sameName) {
                        this.checkDuplicateName(newName);
                    }
                    if (!(newCtx = new DefaultChannelHandlerContext(this, ctx.executor, prev = ctx.prev, next = ctx.next, newName, newHandler)).channel().isRegistered() || newCtx.executor().inEventLoop()) {
                        this.replace0(ctx, newName, newCtx);
                        return ctx.handler();
                    }
                    future = newCtx.executor().submit(new DefaultChannelPipelineModificationTask(this){

                        @Override
                        void doCall() {
                            DefaultChannelPipeline.this.replace0(ctx, newName, newCtx);
                        }
                    });
                }
            }
            Throwable result = future.get();
            if (result != null) {
                throw result;
            }
            return ctx.handler();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(t);
        }
    }

    private void replace0(DefaultChannelHandlerContext ctx, String newName, DefaultChannelHandlerContext newCtx) {
        boolean sameName = ctx.name().equals(newName);
        DefaultChannelHandlerContext prev = ctx.prev;
        DefaultChannelHandlerContext next = ctx.next;
        DefaultChannelPipeline.callBeforeRemove(ctx);
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        prev.next = newCtx;
        next.prev = newCtx;
        if (!sameName) {
            this.name2ctx.remove(ctx.name());
        }
        this.name2ctx.put(newName, newCtx);
        ChannelHandlerLifeCycleException removeException = null;
        ChannelHandlerLifeCycleException addException = null;
        boolean removed = false;
        try {
            DefaultChannelPipeline.callAfterRemove(ctx);
            removed = true;
        }
        catch (ChannelHandlerLifeCycleException e) {
            removeException = e;
        }
        boolean added = false;
        try {
            this.callAfterAdd(newCtx);
            added = true;
        }
        catch (ChannelHandlerLifeCycleException e) {
            addException = e;
        }
        if (!removed && !added) {
            logger.warn(removeException.getMessage(), (Throwable)removeException);
            logger.warn(addException.getMessage(), (Throwable)addException);
            throw new ChannelHandlerLifeCycleException("Both " + ctx.handler().getClass().getName() + ".afterRemove() and " + newCtx.handler().getClass().getName() + ".afterAdd() failed; see logs.");
        }
        if (!removed) {
            throw removeException;
        }
        if (!added) {
            throw addException;
        }
    }

    private static void callBeforeAdd(ChannelHandlerContext ctx) {
        ChannelHandler handler = ctx.handler();
        if (handler instanceof ChannelStateHandlerAdapter) {
            ChannelStateHandlerAdapter h = (ChannelStateHandlerAdapter)handler;
            if (!h.isSharable() && h.added) {
                throw new ChannelHandlerLifeCycleException("Only a @Sharable handler can be added or removed multiple times.");
            }
            h.added = true;
        }
        try {
            handler.beforeAdd(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(handler.getClass().getName() + ".beforeAdd() has thrown an exception; not adding.", t);
        }
    }

    private void callAfterAdd(ChannelHandlerContext ctx) {
        try {
            ctx.handler().afterAdd(ctx);
        }
        catch (Throwable t) {
            boolean removed;
            block5: {
                removed = false;
                try {
                    this.remove((DefaultChannelHandlerContext)ctx);
                    removed = true;
                }
                catch (Throwable t2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + ctx.name(), t2);
                }
            }
            if (removed) {
                throw new ChannelHandlerLifeCycleException(ctx.handler().getClass().getName() + ".afterAdd() has thrown an exception; removed.", t);
            }
            throw new ChannelHandlerLifeCycleException(ctx.handler().getClass().getName() + ".afterAdd() has thrown an exception; also failed to remove.", t);
        }
    }

    private static void callBeforeRemove(ChannelHandlerContext ctx) {
        try {
            ctx.handler().beforeRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(ctx.handler().getClass().getName() + ".beforeRemove() has thrown an exception; not removing.", t);
        }
    }

    private static void callAfterRemove(ChannelHandlerContext ctx) {
        try {
            ctx.handler().afterRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(ctx.handler().getClass().getName() + ".afterRemove() has thrown an exception.", t);
        }
    }

    @Override
    public synchronized ChannelHandler first() {
        DefaultChannelHandlerContext first = this.head.next;
        if (first == null) {
            return null;
        }
        return first.handler();
    }

    @Override
    public synchronized ChannelHandler last() {
        DefaultChannelHandlerContext last = this.tail;
        if (last == this.head || last == null) {
            return null;
        }
        return last.handler();
    }

    @Override
    public synchronized ChannelHandler get(String name) {
        DefaultChannelHandlerContext ctx = this.name2ctx.get(name);
        if (ctx == null) {
            return null;
        }
        return ctx.handler();
    }

    @Override
    public synchronized <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx = this.context(handlerType);
        if (ctx == null) {
            return null;
        }
        return (T)ctx.handler();
    }

    @Override
    public synchronized ChannelHandlerContext context(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.name2ctx.get(name);
    }

    @Override
    public synchronized ChannelHandlerContext context(ChannelHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (this.name2ctx.isEmpty()) {
            return null;
        }
        DefaultChannelHandlerContext ctx = this.head;
        do {
            if (ctx.handler() != handler) continue;
            return ctx;
        } while ((ctx = ctx.next) != null);
        return null;
    }

    @Override
    public synchronized ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        if (this.name2ctx.isEmpty()) {
            return null;
        }
        DefaultChannelHandlerContext ctx = this.head.next;
        do {
            if (!handlerType.isAssignableFrom(ctx.handler().getClass())) continue;
            return ctx;
        } while ((ctx = ctx.next) != null);
        return null;
    }

    @Override
    public List<String> names() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.name2ctx.isEmpty()) {
            return list;
        }
        DefaultChannelHandlerContext ctx = this.head.next;
        do {
            list.add(ctx.name());
        } while ((ctx = ctx.next) != null);
        return list;
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>();
        if (this.name2ctx.isEmpty()) {
            return map;
        }
        DefaultChannelHandlerContext ctx = this.head.next;
        do {
            map.put(ctx.name(), ctx.handler());
        } while ((ctx = ctx.next) != null);
        return map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('{');
        DefaultChannelHandlerContext ctx = this.head.next;
        while (true) {
            buf.append('(');
            buf.append(ctx.name());
            buf.append(" = ");
            buf.append(ctx.handler().getClass().getName());
            buf.append(')');
            ctx = ctx.next;
            if (ctx == null) break;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public MessageBuf<Object> inboundMessageBuffer() {
        if (this.channel.metadata().bufferType() != ChannelBufType.MESSAGE) {
            throw new NoSuchBufferException("The first inbound buffer of this channel must be a message buffer.");
        }
        return this.head.nextInboundMessageBuffer();
    }

    @Override
    public ByteBuf inboundByteBuffer() {
        if (this.channel.metadata().bufferType() != ChannelBufType.BYTE) {
            throw new NoSuchBufferException("The first inbound buffer of this channel must be a byte buffer.");
        }
        return this.head.nextInboundByteBuffer();
    }

    @Override
    public MessageBuf<Object> outboundMessageBuffer() {
        return this.nextOutboundMessageBuffer(this.tail);
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        return this.nextOutboundByteBuffer(this.tail);
    }

    boolean hasNextOutboundByteBuffer(DefaultChannelHandlerContext ctx) {
        while (ctx != null) {
            if (ctx.outByteBridge != null) {
                return true;
            }
            ctx = ctx.prev;
        }
        return false;
    }

    boolean hasNextOutboundMessageBuffer(DefaultChannelHandlerContext ctx) {
        while (ctx != null) {
            if (ctx.outMsgBridge != null) {
                return true;
            }
            ctx = ctx.prev;
        }
        return false;
    }

    ByteBuf nextOutboundByteBuffer(DefaultChannelHandlerContext ctx) {
        Thread currentThread = Thread.currentThread();
        while (true) {
            if (ctx == null) {
                throw new NoSuchBufferException();
            }
            if (ctx.outByteBuf != null) {
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.outByteBuf;
                }
                DefaultChannelHandlerContext.ByteBridge bridge = ctx.outByteBridge.get();
                if (bridge == null && !ctx.outByteBridge.compareAndSet(null, bridge = new DefaultChannelHandlerContext.ByteBridge())) {
                    bridge = ctx.outByteBridge.get();
                }
                return bridge.byteBuf;
            }
            ctx = ctx.prev;
        }
    }

    MessageBuf<Object> nextOutboundMessageBuffer(DefaultChannelHandlerContext ctx) {
        Thread currentThread = Thread.currentThread();
        while (true) {
            if (ctx == null) {
                throw new NoSuchBufferException();
            }
            if (ctx.outMsgBuf != null) {
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.outMsgBuf;
                }
                DefaultChannelHandlerContext.MessageBridge bridge = ctx.outMsgBridge.get();
                if (bridge == null && !ctx.outMsgBridge.compareAndSet(null, bridge = new DefaultChannelHandlerContext.MessageBridge())) {
                    bridge = ctx.outMsgBridge.get();
                }
                return bridge.msgBuf;
            }
            ctx = ctx.prev;
        }
    }

    @Override
    public void fireChannelRegistered() {
        this.head.fireChannelRegistered();
    }

    @Override
    public void fireChannelUnregistered() {
        this.head.fireChannelUnregistered();
    }

    @Override
    public void fireChannelActive() {
        this.firedChannelActive = true;
        this.head.fireChannelActive();
        if (this.fireInboundBufferUpdatedOnActivation) {
            this.fireInboundBufferUpdatedOnActivation = false;
            this.head.fireInboundBufferUpdated();
        }
    }

    @Override
    public void fireChannelInactive() {
        this.head.fireChannelInactive();
    }

    @Override
    public void fireExceptionCaught(Throwable cause) {
        this.head.fireExceptionCaught(cause);
    }

    @Override
    public void fireUserEventTriggered(Object event) {
        this.head.fireUserEventTriggered(event);
    }

    @Override
    public void fireInboundBufferUpdated() {
        if (!this.firedChannelActive) {
            this.fireInboundBufferUpdatedOnActivation = true;
            return;
        }
        this.head.fireInboundBufferUpdated();
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.channel.newFuture());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.channel.newFuture());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.channel.newFuture());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.channel.newFuture());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.channel.newFuture());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.channel.newFuture());
    }

    @Override
    public ChannelFuture flush() {
        return this.flush(this.channel.newFuture());
    }

    @Override
    public ChannelFuture write(Object message) {
        return this.write(message, this.channel.newFuture());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelFuture future) {
        return this.bind(this.firstContext(Integer.MIN_VALUE), localAddress, future);
    }

    ChannelFuture bind(final DefaultChannelHandlerContext ctx, final SocketAddress localAddress, final ChannelFuture future) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.validateFuture(future);
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            try {
                ((ChannelOperationHandler)ctx.handler()).bind(ctx, localAddress, future);
            }
            catch (Throwable t) {
                this.notifyHandlerException(t);
            }
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.bind(ctx, localAddress, future);
                }
            });
        }
        return future;
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelFuture future) {
        return this.connect(remoteAddress, null, future);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelFuture future) {
        return this.connect(this.firstContext(Integer.MIN_VALUE), remoteAddress, localAddress, future);
    }

    ChannelFuture connect(final DefaultChannelHandlerContext ctx, final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelFuture future) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validateFuture(future);
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            try {
                ((ChannelOperationHandler)ctx.handler()).connect(ctx, remoteAddress, localAddress, future);
            }
            catch (Throwable t) {
                this.notifyHandlerException(t);
            }
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.connect(ctx, remoteAddress, localAddress, future);
                }
            });
        }
        return future;
    }

    @Override
    public ChannelFuture disconnect(ChannelFuture future) {
        return this.disconnect(this.firstContext(Integer.MIN_VALUE), future);
    }

    ChannelFuture disconnect(final DefaultChannelHandlerContext ctx, final ChannelFuture future) {
        if (!ctx.channel().metadata().hasDisconnect()) {
            return this.close(ctx, future);
        }
        this.validateFuture(future);
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            try {
                ((ChannelOperationHandler)ctx.handler()).disconnect(ctx, future);
            }
            catch (Throwable t) {
                this.notifyHandlerException(t);
            }
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.disconnect(ctx, future);
                }
            });
        }
        return future;
    }

    @Override
    public ChannelFuture close(ChannelFuture future) {
        return this.close(this.firstContext(Integer.MIN_VALUE), future);
    }

    ChannelFuture close(final DefaultChannelHandlerContext ctx, final ChannelFuture future) {
        this.validateFuture(future);
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            try {
                ((ChannelOperationHandler)ctx.handler()).close(ctx, future);
            }
            catch (Throwable t) {
                this.notifyHandlerException(t);
            }
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.close(ctx, future);
                }
            });
        }
        return future;
    }

    @Override
    public ChannelFuture deregister(ChannelFuture future) {
        return this.deregister(this.firstContext(Integer.MIN_VALUE), future);
    }

    ChannelFuture deregister(final DefaultChannelHandlerContext ctx, final ChannelFuture future) {
        this.validateFuture(future);
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            try {
                ((ChannelOperationHandler)ctx.handler()).deregister(ctx, future);
            }
            catch (Throwable t) {
                this.notifyHandlerException(t);
            }
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.deregister(ctx, future);
                }
            });
        }
        return future;
    }

    @Override
    public ChannelFuture flush(ChannelFuture future) {
        return this.flush(this.firstContext(Integer.MIN_VALUE), future);
    }

    ChannelFuture flush(final DefaultChannelHandlerContext ctx, final ChannelFuture future) {
        this.validateFuture(future);
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            this.flush0(ctx, future);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.flush(ctx, future);
                }
            });
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush0(DefaultChannelHandlerContext ctx, ChannelFuture future) {
        try {
            ctx.flushBridge();
            ((ChannelOperationHandler)ctx.handler()).flush(ctx, future);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            ByteBuf buf;
            if (ctx.outByteBuf != null && !(buf = ctx.outByteBuf).readable()) {
                buf.discardReadBytes();
            }
        }
    }

    @Override
    public ChannelFuture write(Object message, ChannelFuture future) {
        return this.write(this.tail, message, future);
    }

    ChannelFuture write(DefaultChannelHandlerContext ctx, final Object message, final ChannelFuture future) {
        EventExecutor executor;
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.validateFuture(future);
        boolean msgBuf = false;
        while (true) {
            if (ctx == null) {
                throw new NoSuchBufferException();
            }
            if (ctx.hasOutboundMessageBuffer()) {
                msgBuf = true;
                executor = ctx.executor();
                break;
            }
            if (message instanceof ByteBuf && ctx.hasOutboundByteBuffer()) {
                executor = ctx.executor();
                break;
            }
            ctx = ctx.prev;
        }
        if (executor.inEventLoop()) {
            if (msgBuf) {
                ctx.outMsgBuf.add(message);
            } else {
                ByteBuf buf = (ByteBuf)message;
                ctx.outByteBuf.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
            }
            this.flush0(ctx, future);
            return future;
        }
        final DefaultChannelHandlerContext ctx0 = ctx;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultChannelPipeline.this.write(ctx0, message, future);
            }
        });
        return future;
    }

    private void validateFuture(ChannelFuture future) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (future.channel() != this.channel) {
            throw new IllegalArgumentException(String.format("future.channel does not match: %s (expected: %s)", future.channel(), this.channel));
        }
        if (future.isDone()) {
            throw new IllegalArgumentException("future already done");
        }
        if (future instanceof ChannelFuture.Unsafe) {
            throw new IllegalArgumentException("internal use only future not allowed");
        }
    }

    private DefaultChannelHandlerContext firstContext(int direction) {
        assert (direction == 1 || direction == Integer.MIN_VALUE);
        if (direction > 0) {
            return DefaultChannelPipeline.nextContext(this.head.next, direction);
        }
        return DefaultChannelPipeline.nextContext(this.tail, direction);
    }

    static DefaultChannelHandlerContext nextContext(DefaultChannelHandlerContext ctx, int direction) {
        assert (direction == 1 || direction == Integer.MIN_VALUE);
        if (ctx == null) {
            return null;
        }
        DefaultChannelHandlerContext realCtx = ctx;
        if (direction > 0) {
            while ((realCtx.directions & direction) == 0) {
                realCtx = realCtx.next;
                if (realCtx != null) continue;
                return null;
            }
        } else {
            while ((realCtx.directions & direction) == 0) {
                realCtx = realCtx.prev;
                if (realCtx != null) continue;
                return null;
            }
        }
        return realCtx;
    }

    protected void notifyHandlerException(Throwable cause) {
        if (!(cause instanceof ChannelPipelineException)) {
            cause = new ChannelPipelineException(cause);
        }
        if (DefaultChannelPipeline.inExceptionCaught(cause)) {
            if (logger.isWarnEnabled()) {
                logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", cause);
            }
            return;
        }
        this.fireExceptionCaught(cause);
    }

    private static boolean inExceptionCaught(Throwable cause) {
        if (cause == null) {
            return false;
        }
        StackTraceElement[] trace = cause.getStackTrace();
        if (trace != null) {
            for (StackTraceElement t : trace) {
                if (!"exceptionCaught".equals(t.getMethodName())) continue;
                return true;
            }
        }
        return DefaultChannelPipeline.inExceptionCaught(cause.getCause());
    }

    private void checkDuplicateName(String name) {
        if (this.name2ctx.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate handler name: " + name);
        }
    }

    private DefaultChannelHandlerContext getContextOrDie(String name) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.context(name);
        if (ctx == null || ctx == this.head) {
            throw new NoSuchElementException(name);
        }
        return ctx;
    }

    private DefaultChannelHandlerContext getContextOrDie(ChannelHandler handler) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.context(handler);
        if (ctx == null || ctx == this.head) {
            throw new NoSuchElementException(handler.getClass().getName());
        }
        return ctx;
    }

    private DefaultChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> handlerType) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.context(handlerType);
        if (ctx == null || ctx == this.head) {
            throw new NoSuchElementException(handlerType.getName());
        }
        return ctx;
    }

    private final class HeadHandler
    implements ChannelOutboundHandler {
        private HeadHandler() {
        }

        @Override
        public ChannelBuf newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
            switch (DefaultChannelPipeline.this.channel.metadata().bufferType()) {
                case BYTE: {
                    return Unpooled.dynamicBuffer();
                }
                case MESSAGE: {
                    return Unpooled.messageBuffer();
                }
            }
            throw new Error();
        }

        @Override
        public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelFuture future) throws Exception {
            DefaultChannelPipeline.this.unsafe.bind(localAddress, future);
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelFuture future) throws Exception {
            DefaultChannelPipeline.this.unsafe.connect(remoteAddress, localAddress, future);
        }

        @Override
        public void disconnect(ChannelHandlerContext ctx, ChannelFuture future) throws Exception {
            DefaultChannelPipeline.this.unsafe.disconnect(future);
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelFuture future) throws Exception {
            DefaultChannelPipeline.this.unsafe.close(future);
        }

        @Override
        public void deregister(ChannelHandlerContext ctx, ChannelFuture future) throws Exception {
            DefaultChannelPipeline.this.unsafe.deregister(future);
        }

        @Override
        public void flush(ChannelHandlerContext ctx, ChannelFuture future) throws Exception {
            DefaultChannelPipeline.this.unsafe.flush(future);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

