/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.netty.channel;

import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoop extends MultithreadEventExecutor implements EventLoop {

    protected MultithreadEventLoop(int nThreads, ThreadFactory threadFactory,
            Object... args) {
        super(nThreads, threadFactory, args);
    }

    @Override
    protected abstract EventExecutor newChild(ThreadFactory threadFactory, Object... args) throws Exception;

    @Override
    public ChannelFuture register(Channel channel) {
        return ((EventLoop) unsafe().nextChild()).register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelFuture future) {
        return ((EventLoop) unsafe().nextChild()).register(channel, future);
    }
}
