/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.bench.xfer;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.test.udt.util.CustomReporter;
import io.netty.test.udt.util.EchoMessageHandler;
import io.netty.test.udt.util.TrafficControl;
import io.netty.test.udt.util.UnitHelp;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class UdtNetty {
    static final InternalLogger log = InternalLoggerFactory.getInstance(UdtNetty.class);
    static final int time = 600000;
    static final int size = 65536;
    static final Counter benchTime = Metrics.newCounter(UdtNetty.class, (String)"bench time");
    static final Counter benchSize = Metrics.newCounter(UdtNetty.class, (String)"bench size");
    static final Meter rate;

    private UdtNetty() {
    }

    public static void main(String[] args) throws Exception {
        log.info("init");
        TrafficControl.delay(0);
        AtomicBoolean isOn = new AtomicBoolean(true);
        InetSocketAddress addr1 = UnitHelp.localSocketAddress();
        InetSocketAddress addr2 = UnitHelp.localSocketAddress();
        EchoMessageHandler handler1 = new EchoMessageHandler(rate, 65536);
        EchoMessageHandler handler2 = new EchoMessageHandler(null, 65536);
        NioEventLoopGroup group1 = new NioEventLoopGroup(1, Executors.defaultThreadFactory(), NioUdtProvider.MESSAGE_PROVIDER);
        NioEventLoopGroup group2 = new NioEventLoopGroup(1, Executors.defaultThreadFactory(), NioUdtProvider.MESSAGE_PROVIDER);
        Bootstrap peerBoot1 = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)peerBoot1.group((EventLoopGroup)group1)).channelFactory(NioUdtProvider.MESSAGE_RENDEZVOUS)).localAddress((SocketAddress)addr1)).remoteAddress((SocketAddress)addr2).handler((ChannelHandler)handler1);
        Bootstrap peerBoot2 = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)peerBoot2.group((EventLoopGroup)group2)).channelFactory(NioUdtProvider.MESSAGE_RENDEZVOUS)).localAddress((SocketAddress)addr2)).remoteAddress((SocketAddress)addr1).handler((ChannelHandler)handler2);
        ChannelFuture peerFuture1 = peerBoot1.connect();
        ChannelFuture peerFuture2 = peerBoot2.connect();
        CustomReporter.enable(3L, TimeUnit.SECONDS);
        Thread.sleep(600000L);
        isOn.set(false);
        Thread.sleep(1000L);
        peerFuture1.channel().close().sync();
        peerFuture2.channel().close().sync();
        Thread.sleep(1000L);
        group1.shutdownGracefully();
        group2.shutdownGracefully();
        Metrics.defaultRegistry().shutdown();
        TrafficControl.delay(0);
        log.info("done");
    }

    static {
        benchTime.inc(600000L);
        benchSize.inc(65536L);
        rate = Metrics.newMeter(UdtNetty.class, (String)"rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    TrafficControl.delay(0);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }
}

