/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.google.caliper.SimpleBenchmark;
import io.netty.test.udt.util.CaliperMeasure;
import io.netty.test.udt.util.TrafficControl;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class CaliperBench
extends SimpleBenchmark {
    protected final InternalLogger log = InternalLoggerFactory.getInstance(((Object)((Object)this)).getClass());
    private volatile CaliperMeasure measure;

    protected CaliperMeasure measure() {
        return this.measure;
    }

    protected void setUp() throws Exception {
        this.measure = new CaliperMeasure();
    }

    protected void tearDown() throws Exception {
        this.measure.shutdown();
    }

    protected long markStep() {
        return 3000L;
    }

    protected void markWait(long time) throws Exception {
        long timeStart = System.currentTimeMillis();
        while (true) {
            Thread.sleep(this.markStep());
            this.measure().mark();
            long timeFinish = System.currentTimeMillis();
            if (timeFinish - timeStart >= time) {
                System.out.print("+\n");
                return;
            }
            System.out.print("-");
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    TrafficControl.delay(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

