/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class EchoByteHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EchoByteHandler.class);
    private final ByteBuf message;
    private final Meter meter;

    public Meter meter() {
        return this.meter;
    }

    public EchoByteHandler(Meter meter, int messageSize) {
        this.meter = meter;
        this.message = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active {}", (Object)NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.write((Object)this.message);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        for (int i = 0; i < msgs.size(); ++i) {
            ByteBuf buf = (ByteBuf)msgs.get(i);
            if (this.meter != null) {
                this.meter.mark((long)buf.readableBytes());
            }
            buf.retain();
        }
        ctx.write(msgs);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        log.error("exception : {}", (Object)e.getMessage());
        ctx.close();
    }
}

